/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.mixpanel.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.mixpanel.client.MixpanelEvent;
import io.camunda.optimize.service.mixpanel.client.MixpanelImportResponse;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.analytics.MixpanelConfiguration;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSaaSCondition.class})
public class MixpanelClient {
    private static final Logger LOG = LoggerFactory.getLogger(MixpanelClient.class);
    private final ConfigurationService configurationService;
    private final ObjectMapper objectMapper;
    private final CloseableHttpClient httpClient;

    @Autowired
    public MixpanelClient(ConfigurationService configurationService, ObjectMapper objectMapper) {
        this(configurationService, objectMapper, HttpClients.createDefault());
    }

    public MixpanelClient(ConfigurationService configurationService, ObjectMapper objectMapper, CloseableHttpClient httpClient) {
        this.configurationService = configurationService;
        this.objectMapper = objectMapper;
        this.httpClient = httpClient;
    }

    @PreDestroy
    public void destroy() throws IOException {
        this.httpClient.close();
    }

    public void importEvent(MixpanelEvent event) {
        HttpPost importRequest = new HttpPost(this.getMixpanelConfiguration().getImportUrl() + "?strict=1&project_id=" + this.getMixpanelConfiguration().getProjectId());
        importRequest.setHeader("Content-Type", "application/json");
        importRequest.setHeader("Authorization", this.getAuthHeader());
        try {
            importRequest.setEntity((HttpEntity)new StringEntity(this.objectMapper.writeValueAsString(List.of(event)), ContentType.APPLICATION_JSON));
        }
        catch (JsonProcessingException e) {
            throw new OptimizeRuntimeException("Failed to serialize event for Mixpanel.", (Throwable)e);
        }
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)importRequest);){
            this.checkResponse(response);
        }
        catch (IOException e) {
            throw new OptimizeRuntimeException("Could not import event to Mixpanel.", (Throwable)e);
        }
    }

    private void checkResponse(CloseableHttpResponse response) {
        try {
            if (response.getStatusLine().getStatusCode() != HttpStatus.OK.value()) {
                throw new OptimizeRuntimeException(String.format("Unexpected response status on a mixpanel import: %s, response body: %s", response.getStatusLine().getStatusCode(), EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8)));
            }
            MixpanelImportResponse mixpanelResponse = (MixpanelImportResponse)this.objectMapper.readValue(response.getEntity().getContent(), MixpanelImportResponse.class);
            if (!mixpanelResponse.isSuccessful()) {
                throw new OptimizeRuntimeException(String.format("Mixpanel import was not successful, error: %s", mixpanelResponse.getError()));
            }
        }
        catch (IOException e) {
            LOG.warn("Could not parse response from Mixpanel.", (Throwable)e);
        }
    }

    private String getAuthHeader() {
        String auth = this.getServiceAccount().getUsername() + ":" + this.getServiceAccount().getSecret();
        return "Basic " + new String(Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8)));
    }

    private MixpanelConfiguration.ServiceAccount getServiceAccount() {
        return this.getMixpanelConfiguration().getServiceAccount();
    }

    private MixpanelConfiguration getMixpanelConfiguration() {
        return this.configurationService.getAnalytics().getMixpanel();
    }
}

