/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.mixpanel;

import io.camunda.optimize.service.AbstractScheduledService;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.mixpanel.MixpanelReportingService;
import io.camunda.optimize.service.util.configuration.ConfigurationReloadable;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.TelemetryConfiguration;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSaaSCondition.class})
public class MixpanelDataScheduler
extends AbstractScheduledService
implements ConfigurationReloadable {
    private static final Logger LOG = LoggerFactory.getLogger(MixpanelDataScheduler.class);
    private final ConfigurationService configurationService;
    private final MixpanelReportingService mixpanelReportingService;

    public MixpanelDataScheduler(ConfigurationService configurationService, MixpanelReportingService mixpanelReportingService) {
        this.configurationService = configurationService;
        this.mixpanelReportingService = mixpanelReportingService;
    }

    @PostConstruct
    public void init() {
        LOG.info("Initializing MixpanelDataScheduler");
        this.getTelemetryConfiguration().validate();
        this.startMixpanelTelemetryScheduling();
    }

    @Override
    protected void run() {
        LOG.info("Checking whether Mixpanel telemetry data can be sent.");
        if (this.configurationService.getTelemetryConfiguration().isInitializeTelemetry()) {
            try {
                this.mixpanelReportingService.sendHeartbeatData();
                LOG.info("Mixpanel telemetry data was sent.");
            }
            catch (OptimizeRuntimeException e) {
                LOG.error("Failed to send Mixpanel telemetry.", (Throwable)e);
            }
        } else {
            LOG.info("Mixpanel telemetry disabled.");
        }
    }

    @Override
    protected Trigger createScheduleTrigger() {
        return new PeriodicTrigger(Duration.ofHours(this.getTelemetryConfiguration().getReportingIntervalInHours()));
    }

    public void reloadConfiguration(ApplicationContext context) {
        this.init();
    }

    public synchronized boolean startMixpanelTelemetryScheduling() {
        LOG.info("Starting mixpanel scheduling");
        return this.startScheduling();
    }

    @PreDestroy
    public synchronized void stopMixpanelTelemetryScheduling() {
        LOG.info("Stopping mixpanel scheduling");
        this.stopScheduling();
    }

    protected TelemetryConfiguration getTelemetryConfiguration() {
        return this.configurationService.getTelemetryConfiguration();
    }
}

