/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.zeebe.mediator;

import io.camunda.optimize.MetricEnum;
import io.camunda.optimize.OptimizeMetrics;
import io.camunda.optimize.dto.zeebe.usertask.ZeebeUserTaskRecordDto;
import io.camunda.optimize.service.importing.PositionBasedImportMediator;
import io.camunda.optimize.service.importing.engine.mediator.MediatorRank;
import io.camunda.optimize.service.importing.engine.service.zeebe.ZeebeUserTaskImportService;
import io.camunda.optimize.service.importing.zeebe.db.ZeebeUserTaskFetcher;
import io.camunda.optimize.service.importing.zeebe.handler.ZeebeUserTaskImportIndexHandler;
import io.camunda.optimize.service.util.BackoffCalculator;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.zeebe.protocol.record.ValueType;
import java.util.List;

public class ZeebeUserTaskImportMediator
extends PositionBasedImportMediator<ZeebeUserTaskImportIndexHandler, ZeebeUserTaskRecordDto> {
    private ZeebeUserTaskFetcher zeebeUserTaskFetcher;

    public ZeebeUserTaskImportMediator(ZeebeUserTaskImportIndexHandler importIndexHandler, ZeebeUserTaskFetcher zeebeUserTaskFetcher, ZeebeUserTaskImportService importService, ConfigurationService configurationService, BackoffCalculator idleBackoffCalculator) {
        this.importIndexHandler = importIndexHandler;
        this.zeebeUserTaskFetcher = zeebeUserTaskFetcher;
        this.importService = importService;
        this.configurationService = configurationService;
        this.idleBackoffCalculator = idleBackoffCalculator;
    }

    @Override
    public MediatorRank getRank() {
        return MediatorRank.INSTANCE_SUB_ENTITIES;
    }

    @Override
    protected boolean importNextPage(Runnable importCompleteCallback) {
        return this.importNextPagePositionBased(this.getUserTasks(), importCompleteCallback);
    }

    @Override
    protected String getRecordType() {
        return ValueType.USER_TASK.name();
    }

    @Override
    protected Integer getPartitionId() {
        return this.zeebeUserTaskFetcher.getPartitionId();
    }

    private List<ZeebeUserTaskRecordDto> getUserTasks() {
        return (List)OptimizeMetrics.getTimer(MetricEnum.NEW_PAGE_FETCH_TIME_METRIC, this.getRecordType(), this.getPartitionId()).record(() -> this.zeebeUserTaskFetcher.getZeebeRecordsForPrefixAndPartitionFrom(((ZeebeUserTaskImportIndexHandler)this.importIndexHandler).getNextPage()));
    }
}

