/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.zeebe.mediator;

import io.camunda.optimize.MetricEnum;
import io.camunda.optimize.OptimizeMetrics;
import io.camunda.optimize.dto.zeebe.definition.ZeebeProcessDefinitionRecordDto;
import io.camunda.optimize.service.importing.PositionBasedImportMediator;
import io.camunda.optimize.service.importing.engine.mediator.MediatorRank;
import io.camunda.optimize.service.importing.engine.service.zeebe.ZeebeProcessDefinitionImportService;
import io.camunda.optimize.service.importing.zeebe.db.ZeebeProcessDefinitionFetcher;
import io.camunda.optimize.service.importing.zeebe.handler.ZeebeProcessDefinitionImportIndexHandler;
import io.camunda.optimize.service.util.BackoffCalculator;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.zeebe.protocol.record.ValueType;
import java.util.List;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ZeebeProcessDefinitionImportMediator
extends PositionBasedImportMediator<ZeebeProcessDefinitionImportIndexHandler, ZeebeProcessDefinitionRecordDto> {
    private final ZeebeProcessDefinitionFetcher zeebeProcessDefinitionFetcher;

    public ZeebeProcessDefinitionImportMediator(ZeebeProcessDefinitionImportIndexHandler importIndexHandler, ZeebeProcessDefinitionFetcher zeebeProcessDefinitionFetcher, ZeebeProcessDefinitionImportService importService, ConfigurationService configurationService, BackoffCalculator idleBackoffCalculator) {
        this.importIndexHandler = importIndexHandler;
        this.zeebeProcessDefinitionFetcher = zeebeProcessDefinitionFetcher;
        this.importService = importService;
        this.configurationService = configurationService;
        this.idleBackoffCalculator = idleBackoffCalculator;
    }

    @Override
    public MediatorRank getRank() {
        return MediatorRank.DEFINITION;
    }

    @Override
    protected boolean importNextPage(Runnable importCompleteCallback) {
        return this.importNextPagePositionBased(this.getDefinitions(), importCompleteCallback);
    }

    @Override
    protected String getRecordType() {
        return ValueType.PROCESS.name();
    }

    @Override
    protected Integer getPartitionId() {
        return this.zeebeProcessDefinitionFetcher.getPartitionId();
    }

    private List<ZeebeProcessDefinitionRecordDto> getDefinitions() {
        return (List)OptimizeMetrics.getTimer(MetricEnum.NEW_PAGE_FETCH_TIME_METRIC, this.getRecordType(), this.getPartitionId()).record(() -> this.zeebeProcessDefinitionFetcher.getZeebeRecordsForPrefixAndPartitionFrom(((ZeebeProcessDefinitionImportIndexHandler)this.importIndexHandler).getNextPage()));
    }
}

