/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.zeebe.mediator;

import io.camunda.optimize.dto.optimize.datasource.ZeebeDataSourceDto;
import io.camunda.optimize.dto.optimize.index.PositionBasedImportIndexDto;
import io.camunda.optimize.service.importing.ImportIndexHandler;
import io.camunda.optimize.service.importing.ImportIndexHandlerRegistry;
import io.camunda.optimize.service.importing.ImportMediator;
import io.camunda.optimize.service.importing.engine.mediator.AbstractStoreIndexesImportMediator;
import io.camunda.optimize.service.importing.engine.service.StorePositionBasedIndexImportService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class StorePositionBasedImportProgressMediator
extends AbstractStoreIndexesImportMediator<StorePositionBasedIndexImportService>
implements ImportMediator {
    private static final Logger LOG = LoggerFactory.getLogger(StorePositionBasedImportProgressMediator.class);
    private final ImportIndexHandlerRegistry importIndexHandlerRegistry;
    private final ZeebeDataSourceDto dataSource;

    public StorePositionBasedImportProgressMediator(ImportIndexHandlerRegistry importIndexHandlerRegistry, StorePositionBasedIndexImportService importService, ConfigurationService configurationService, ZeebeDataSourceDto zeebeDataSourceDto) {
        super(importService, configurationService);
        this.importIndexHandlerRegistry = importIndexHandlerRegistry;
        this.dataSource = zeebeDataSourceDto;
    }

    @Override
    public CompletableFuture<Void> runImport() {
        CompletableFuture<Void> importCompleted = new CompletableFuture<Void>();
        this.dateUntilJobCreationIsBlocked = this.calculateDateUntilJobCreationIsBlocked();
        try {
            List<PositionBasedImportIndexDto> importIndexes = Optional.ofNullable(this.importIndexHandlerRegistry.getPositionBasedHandlers(this.dataSource.getPartitionId())).stream().flatMap(Collection::stream).map(ImportIndexHandler::getIndexStateDto).filter(Objects::nonNull).map(PositionBasedImportIndexDto.class::cast).collect(Collectors.toList());
            ((StorePositionBasedIndexImportService)this.importService).executeImport(importIndexes, () -> importCompleted.complete(null));
        }
        catch (Exception e) {
            LOG.error("Could not execute import for storing zeebe position based index information!", (Throwable)e);
            importCompleted.complete(null);
        }
        return importCompleted;
    }
}

