/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.zeebe.fetcher.os;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.importing.page.PositionBasedImportPage;
import io.camunda.optimize.service.importing.zeebe.fetcher.AbstractZeebeRecordFetcher;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.CountRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;

@Conditional(value={OpenSearchCondition.class})
public abstract class AbstractZeebeRecordFetcherOS<T>
extends AbstractZeebeRecordFetcher<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractZeebeRecordFetcherOS.class);
    private final OptimizeOpenSearchClient osClient;

    protected AbstractZeebeRecordFetcherOS(int partitionId, OptimizeOpenSearchClient osClient, ObjectMapper objectMapper, ConfigurationService configurationService) {
        super(partitionId, configurationService);
        this.osClient = osClient;
    }

    @Override
    protected boolean isZeebeInstanceIndexNotFoundException(Exception e) {
        if (e instanceof OpenSearchException) {
            return e.getMessage().contains("index_not_found_exception");
        }
        return false;
    }

    @Override
    protected List<T> fetchZeebeRecordsForPrefixAndPartitionFrom(PositionBasedImportPage positionBasedImportPage) throws Exception {
        SearchRequest.Builder builder = new SearchRequest.Builder().index(this.getIndexAlias(), new String[0]).routing(String.valueOf(this.partitionId)).requestCache(Boolean.FALSE).query(this.getRecordQuery(positionBasedImportPage)).size(Integer.valueOf(this.getDynamicBatchSize())).sort(this.buildSortOptions(positionBasedImportPage), new SortOptions[0]);
        SearchResponse searchResponse = this.osClient.getOpenSearchClient().search(builder.build(), this.getRecordDtoClass());
        if (!searchResponse.shards().failures().isEmpty() || searchResponse.shards().total().intValue() > searchResponse.shards().failures().size() + searchResponse.shards().successful().intValue()) {
            throw new OptimizeRuntimeException("Not all shards could be searched successfully");
        }
        return searchResponse.hits().hits().stream().map(Hit::source).toList();
    }

    private Query getRecordQuery(PositionBasedImportPage positionBasedImportPage) {
        if (!positionBasedImportPage.isHasSeenSequenceField() || this.nextSequenceRecordIsBeyondSequenceQuery(positionBasedImportPage)) {
            return this.buildPositionQuery(positionBasedImportPage);
        }
        return this.buildSequenceQuery(positionBasedImportPage);
    }

    private boolean nextSequenceRecordIsBeyondSequenceQuery(PositionBasedImportPage positionBasedImportPage) {
        block6: {
            if (this.getConsecutiveEmptyPages() < this.getZeebeImportConfig().getMaxEmptyPagesToImport()) {
                return false;
            }
            CountRequest.Builder builder = new CountRequest.Builder().index(this.getIndexAlias(), new String[0]).routing(String.valueOf(this.partitionId)).query(this.buildPositionQuery(positionBasedImportPage));
            try {
                LOG.info("Using the position query to see if there are new records in the {} index on partition {}", (Object)this.getBaseIndexName(), (Object)this.partitionId);
                long numberOfRecordsFound = this.osClient.getOpenSearchClient().count(builder.build()).count();
                if (numberOfRecordsFound > 0L) {
                    LOG.info("Found {} records in index {} on partition {} that can't be imported by the current sequence query. Will revert to position query for the next fetch attempt", new Object[]{numberOfRecordsFound, this.getBaseIndexName(), this.partitionId});
                    return true;
                }
                LOG.info("There are no newer records to process, so empty pages of records are currently expected");
            }
            catch (Exception e) {
                if (this.isZeebeInstanceIndexNotFoundException(e)) {
                    LOG.warn("No Zeebe index of type {} found to count records from!", (Object)this.getIndexAlias());
                } else {
                    LOG.warn("There was an error when looking for records to import beyond the boundaries of the sequence request" + String.valueOf(e));
                }
                if (!(e instanceof InterruptedException)) break block6;
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    private Query buildPositionQuery(PositionBasedImportPage positionBasedImportPage) {
        LOG.trace("using position query for records of {} on partition {}", (Object)this.getBaseIndexName(), (Object)this.getPartitionId());
        return QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"partitionId", (Integer)this.partitionId), QueryDSL.gt((String)"position", (Object)positionBasedImportPage.getPosition())});
    }

    private Query buildSequenceQuery(PositionBasedImportPage positionBasedImportPage) {
        LOG.trace("using sequence query for records of {} on partition {}", (Object)this.getBaseIndexName(), (Object)this.getPartitionId());
        return QueryDSL.gtLte((String)"sequence", (Object)positionBasedImportPage.getSequence(), (Object)(positionBasedImportPage.getSequence() + (long)this.getDynamicBatchSize()));
    }

    private SortOptions buildSortOptions(PositionBasedImportPage positionBasedImportPage) {
        return (SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(this.getSortField(positionBasedImportPage)).order(SortOrder.Asc).build()).build();
    }
}

