/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.ingested.handler;

import io.camunda.optimize.service.importing.ImportIndexHandler;
import io.camunda.optimize.service.importing.ingested.handler.ExternalVariableUpdateImportIndexHandler;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class IngestedImportIndexHandlerProvider {
    private final BeanFactory beanFactory;
    private Map<String, ImportIndexHandler<?, ?>> allHandlers;
    private ExternalVariableUpdateImportIndexHandler externalVariableUpdateImportIndexHandler;

    public IngestedImportIndexHandlerProvider(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @PostConstruct
    public void init() {
        ExternalVariableUpdateImportIndexHandler importIndexHandlerInstance;
        this.allHandlers = new HashMap();
        this.externalVariableUpdateImportIndexHandler = importIndexHandlerInstance = (ExternalVariableUpdateImportIndexHandler)this.getImportIndexHandlerInstance(ExternalVariableUpdateImportIndexHandler.class);
        this.allHandlers.put(ExternalVariableUpdateImportIndexHandler.class.getSimpleName(), importIndexHandlerInstance);
    }

    public Collection<ImportIndexHandler<?, ?>> getAllHandlers() {
        return this.allHandlers.values();
    }

    private <R, C extends Class<R>> R getImportIndexHandlerInstance(C requiredType) {
        Object result = this.isInstantiated(requiredType) ? requiredType.cast(this.allHandlers.get(requiredType.getSimpleName())) : this.beanFactory.getBean(requiredType);
        return (R)result;
    }

    private boolean isInstantiated(Class<?> handlerClass) {
        return this.allHandlers.get(handlerClass.getSimpleName()) != null;
    }

    public ExternalVariableUpdateImportIndexHandler getExternalVariableUpdateImportIndexHandler() {
        return this.externalVariableUpdateImportIndexHandler;
    }
}

