/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.ingested.fetcher;

import io.camunda.optimize.dto.optimize.query.variable.ExternalProcessVariableDto;
import io.camunda.optimize.service.db.reader.ExternalVariableReader;
import io.camunda.optimize.service.importing.page.TimestampBasedImportPage;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.time.OffsetDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ExternalVariableUpdateInstanceFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalVariableUpdateInstanceFetcher.class);
    private final ExternalVariableReader variableReader;
    private final ConfigurationService configurationService;

    public ExternalVariableUpdateInstanceFetcher(ExternalVariableReader variableReader, ConfigurationService configurationService) {
        this.variableReader = variableReader;
        this.configurationService = configurationService;
    }

    public List<ExternalProcessVariableDto> fetchVariableInstanceUpdates(TimestampBasedImportPage page) {
        return this.variableReader.getVariableUpdatesIngestedAfter(page.getTimestampOfLastEntity().toInstant().toEpochMilli(), this.configurationService.getExternalVariableConfiguration().getImportConfiguration().getMaxPageSize());
    }

    public List<ExternalProcessVariableDto> fetchVariableInstanceUpdates(OffsetDateTime endTimeOfLastInstance) {
        return this.variableReader.getVariableUpdatesIngestedAt(endTimeOfLastInstance.toInstant().toEpochMilli());
    }
}

