/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.engine.service.zeebe;

import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.importing.UserTaskIdentityOperationType;
import io.camunda.optimize.dto.optimize.persistence.AssigneeOperationDto;
import io.camunda.optimize.dto.optimize.query.process.FlowNodeInstanceDto;
import io.camunda.optimize.dto.zeebe.usertask.ZeebeUserTaskDataDto;
import io.camunda.optimize.dto.zeebe.usertask.ZeebeUserTaskRecordDto;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.writer.ProcessInstanceWriter;
import io.camunda.optimize.service.importing.engine.service.zeebe.ZeebeProcessInstanceSubEntityImportService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;
import io.netty.util.internal.StringUtil;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeebeUserTaskImportService
extends ZeebeProcessInstanceSubEntityImportService<ZeebeUserTaskRecordDto> {
    public static final Set<UserTaskIntent> INTENTS_TO_IMPORT = Set.of(UserTaskIntent.CREATING, UserTaskIntent.ASSIGNED, UserTaskIntent.COMPLETED, UserTaskIntent.CANCELED);
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeUserTaskImportService.class);

    public ZeebeUserTaskImportService(ConfigurationService configurationService, ProcessInstanceWriter processInstanceWriter, int partitionId, ProcessDefinitionReader processDefinitionReader, DatabaseClient databaseClient) {
        super(configurationService, processInstanceWriter, partitionId, processDefinitionReader, databaseClient, "user-task");
    }

    @Override
    List<ProcessInstanceDto> filterAndMapZeebeRecordsToOptimizeEntities(List<ZeebeUserTaskRecordDto> userTaskRecords) {
        List<ProcessInstanceDto> optimizeDtos = userTaskRecords.stream().filter(zeebeRecord -> INTENTS_TO_IMPORT.contains(zeebeRecord.getIntent())).collect(Collectors.groupingBy(zeebeRecord -> ((ZeebeUserTaskDataDto)zeebeRecord.getValue()).getProcessInstanceKey())).values().stream().map(this::createProcessInstanceForData).toList();
        LOG.debug("Processing {} fetched zeebe userTask records, of which {} are relevant to Optimize and will be imported.", (Object)userTaskRecords.size(), (Object)optimizeDtos.size());
        return optimizeDtos;
    }

    private ProcessInstanceDto createProcessInstanceForData(List<ZeebeUserTaskRecordDto> userTaskRecordsForInstance) {
        ZeebeUserTaskDataDto firstRecordValue = (ZeebeUserTaskDataDto)userTaskRecordsForInstance.get(0).getValue();
        ProcessInstanceDto instanceToAdd = this.createSkeletonProcessInstance(firstRecordValue.getBpmnProcessId(), firstRecordValue.getProcessInstanceKey(), firstRecordValue.getProcessDefinitionKey(), firstRecordValue.getTenantId());
        this.updateUserTaskData(instanceToAdd, userTaskRecordsForInstance);
        return instanceToAdd;
    }

    private void updateUserTaskData(ProcessInstanceDto instanceToAdd, List<ZeebeUserTaskRecordDto> userTaskRecordsForInstance) {
        HashMap userTaskInstancesByKey = new HashMap();
        userTaskRecordsForInstance.forEach(zeebeUserTaskInstanceRecord -> {
            long recordKey = zeebeUserTaskInstanceRecord.getKey();
            FlowNodeInstanceDto userTaskForKey = userTaskInstancesByKey.getOrDefault(recordKey, this.createSkeletonUserTaskInstance((ZeebeUserTaskDataDto)zeebeUserTaskInstanceRecord.getValue()));
            UserTaskIntent userTaskRecordIntent = (UserTaskIntent)zeebeUserTaskInstanceRecord.getIntent();
            if (userTaskRecordIntent == UserTaskIntent.CREATING) {
                userTaskForKey.setStartDate(zeebeUserTaskInstanceRecord.getDateForTimestamp());
                if (!StringUtil.isNullOrEmpty((String)((ZeebeUserTaskDataDto)zeebeUserTaskInstanceRecord.getValue()).getAssignee())) {
                    this.updateUserTaskAssigneeOperations((ZeebeUserTaskRecordDto)zeebeUserTaskInstanceRecord, userTaskForKey);
                }
            } else if (userTaskRecordIntent == UserTaskIntent.COMPLETED) {
                userTaskForKey.setEndDate(zeebeUserTaskInstanceRecord.getDateForTimestamp());
            } else if (userTaskRecordIntent == UserTaskIntent.CANCELED) {
                userTaskForKey.setCanceled(Boolean.valueOf(true));
                userTaskForKey.setEndDate(zeebeUserTaskInstanceRecord.getDateForTimestamp());
            } else if (userTaskRecordIntent == UserTaskIntent.ASSIGNED) {
                this.updateUserTaskAssigneeOperations((ZeebeUserTaskRecordDto)zeebeUserTaskInstanceRecord, userTaskForKey);
            }
            userTaskForKey.setAssignee(this.parseAssignee((ZeebeUserTaskDataDto)zeebeUserTaskInstanceRecord.getValue()));
            userTaskForKey.setDueDate(((ZeebeUserTaskDataDto)zeebeUserTaskInstanceRecord.getValue()).getDateForDueDate());
            userTaskInstancesByKey.put(recordKey, userTaskForKey);
        });
        userTaskInstancesByKey.values().forEach(this::updateUserTaskDurations);
        instanceToAdd.setFlowNodeInstances(new ArrayList(userTaskInstancesByKey.values()));
    }

    private FlowNodeInstanceDto createSkeletonUserTaskInstance(ZeebeUserTaskDataDto userTaskData) {
        FlowNodeInstanceDto flowNodeInstanceDto = new FlowNodeInstanceDto();
        flowNodeInstanceDto.setFlowNodeInstanceId(String.valueOf(userTaskData.getElementInstanceKey()));
        flowNodeInstanceDto.setFlowNodeId(userTaskData.getElementId());
        flowNodeInstanceDto.setFlowNodeType("userTask");
        flowNodeInstanceDto.setProcessInstanceId(String.valueOf(userTaskData.getProcessInstanceKey()));
        flowNodeInstanceDto.setCanceled(Boolean.valueOf(false));
        flowNodeInstanceDto.setDefinitionKey(userTaskData.getBpmnProcessId());
        flowNodeInstanceDto.setDefinitionVersion(String.valueOf(userTaskData.getProcessDefinitionVersion()));
        flowNodeInstanceDto.setTenantId(userTaskData.getTenantId());
        flowNodeInstanceDto.setUserTaskInstanceId(String.valueOf(userTaskData.getUserTaskKey()));
        return flowNodeInstanceDto;
    }

    private void updateUserTaskDurations(FlowNodeInstanceDto userTaskToAdd) {
        if (userTaskToAdd.getStartDate() != null && userTaskToAdd.getEndDate() != null) {
            userTaskToAdd.setTotalDurationInMs(Long.valueOf(userTaskToAdd.getStartDate().until(userTaskToAdd.getEndDate(), ChronoUnit.MILLIS)));
        }
        if (!(userTaskToAdd.getStartDate() == null || userTaskToAdd.getEndDate() == null && userTaskToAdd.getAssigneeOperations().isEmpty())) {
            long totalIdleTimeInMs = 0L;
            long totalWorkTimeInMs = 0L;
            boolean workTimeHasChanged = false;
            boolean idleTimeHasChanged = false;
            if (!userTaskToAdd.getAssigneeOperations().isEmpty()) {
                int i;
                List allUnclaimTimestamps = userTaskToAdd.getAssigneeOperations().stream().filter(operation -> UserTaskIdentityOperationType.UNCLAIM_OPERATION_TYPE.toString().equals(operation.getOperationType())).map(AssigneeOperationDto::getTimestamp).collect(Collectors.toList());
                allUnclaimTimestamps.add(userTaskToAdd.getStartDate());
                Optional.ofNullable(userTaskToAdd.getEndDate()).ifPresent(allUnclaimTimestamps::add);
                allUnclaimTimestamps.sort(Comparator.naturalOrder());
                List<OffsetDateTime> allClaimTimestamps = userTaskToAdd.getAssigneeOperations().stream().filter(operation -> UserTaskIdentityOperationType.CLAIM_OPERATION_TYPE.toString().equals(operation.getOperationType())).map(AssigneeOperationDto::getTimestamp).sorted(Comparator.naturalOrder()).toList();
                for (i = 0; i < allUnclaimTimestamps.size() && i < allClaimTimestamps.size(); ++i) {
                    OffsetDateTime unclaimDate = (OffsetDateTime)allUnclaimTimestamps.get(i);
                    OffsetDateTime claimDate = allClaimTimestamps.get(i);
                    totalIdleTimeInMs += Duration.between(unclaimDate, claimDate).toMillis();
                    idleTimeHasChanged = true;
                }
                for (i = 0; i < allUnclaimTimestamps.size() - 1 && i < allClaimTimestamps.size(); ++i) {
                    OffsetDateTime claimDate = allClaimTimestamps.get(i);
                    OffsetDateTime unclaimDate = (OffsetDateTime)allUnclaimTimestamps.get(i + 1);
                    totalWorkTimeInMs += Duration.between(claimDate, unclaimDate).toMillis();
                    workTimeHasChanged = true;
                }
                if (allUnclaimTimestamps.size() - allClaimTimestamps.size() == 2) {
                    OffsetDateTime lastUnclaim = (OffsetDateTime)allUnclaimTimestamps.get(allUnclaimTimestamps.size() - 1);
                    OffsetDateTime secondToLastUnclaim = (OffsetDateTime)allUnclaimTimestamps.get(allUnclaimTimestamps.size() - 2);
                    totalIdleTimeInMs += Duration.between(lastUnclaim, secondToLastUnclaim).toMillis();
                    idleTimeHasChanged = true;
                }
            } else if (userTaskToAdd.getTotalDurationInMs() != null) {
                if (Boolean.TRUE.equals(userTaskToAdd.getCanceled())) {
                    totalIdleTimeInMs = userTaskToAdd.getTotalDurationInMs();
                    totalWorkTimeInMs = 0L;
                } else {
                    totalIdleTimeInMs = 0L;
                    totalWorkTimeInMs = userTaskToAdd.getTotalDurationInMs();
                }
                workTimeHasChanged = true;
                idleTimeHasChanged = true;
            }
            if (idleTimeHasChanged) {
                userTaskToAdd.setIdleDurationInMs(Long.valueOf(totalIdleTimeInMs));
            }
            if (workTimeHasChanged) {
                userTaskToAdd.setWorkDurationInMs(Long.valueOf(totalWorkTimeInMs));
            }
        }
    }

    private void updateUserTaskAssigneeOperations(ZeebeUserTaskRecordDto zeebeUserTaskRecord, FlowNodeInstanceDto flowNodeToAdd) {
        flowNodeToAdd.getAssigneeOperations().add(this.createAssigneeOperationDto(zeebeUserTaskRecord));
    }

    private AssigneeOperationDto createAssigneeOperationDto(ZeebeUserTaskRecordDto zeebeUserTaskRecord) {
        AssigneeOperationDto assigneeOperationDto = new AssigneeOperationDto();
        assigneeOperationDto.setId(String.valueOf(zeebeUserTaskRecord.getKey()));
        assigneeOperationDto.setUserId(this.parseAssignee((ZeebeUserTaskDataDto)zeebeUserTaskRecord.getValue()));
        assigneeOperationDto.setOperationType(StringUtil.isNullOrEmpty((String)((ZeebeUserTaskDataDto)zeebeUserTaskRecord.getValue()).getAssignee()) ? UserTaskIdentityOperationType.UNCLAIM_OPERATION_TYPE.toString() : UserTaskIdentityOperationType.CLAIM_OPERATION_TYPE.toString());
        assigneeOperationDto.setTimestamp(zeebeUserTaskRecord.getDateForTimestamp());
        return assigneeOperationDto;
    }

    private String parseAssignee(ZeebeUserTaskDataDto zeebeUserTaskData) {
        return StringUtil.isNullOrEmpty((String)zeebeUserTaskData.getAssignee()) ? null : zeebeUserTaskData.getAssignee();
    }
}

