/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing.engine.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.sisyphsu.dateparser.DateParserUtils;
import com.github.wnameless.json.base.JacksonJsonCore;
import com.github.wnameless.json.base.JsonCore;
import com.github.wnameless.json.flattener.FlattenMode;
import com.github.wnameless.json.flattener.JsonFlattener;
import com.github.wnameless.json.flattener.JsonifyArrayList;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableUpdateDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ObjectVariableService {
    private static final String LIST_SIZE_VARIABLE_SUFFIX = "_listSize";
    private static final DateTimeFormatter OPTIMIZE_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final Logger LOG = LoggerFactory.getLogger(ObjectVariableService.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ObjectVariableService() {
        this.objectMapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        this.objectMapper.configure(DeserializationFeature.USE_LONG_FOR_INTS, true);
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public List<ProcessVariableDto> convertToProcessVariableDtos(List<ProcessVariableUpdateDto> variables) {
        ArrayList<ProcessVariableDto> resultList = new ArrayList<ProcessVariableDto>();
        for (ProcessVariableUpdateDto variableUpdateDto : variables) {
            if (this.isNonNullNativeJsonVariable(variableUpdateDto) || this.isNonNullObjectVariable(variableUpdateDto)) {
                if (!this.isSupportedSerializationFormat(variableUpdateDto)) continue;
                this.flattenJsonObjectVariableAndAddToResult(variableUpdateDto, resultList);
                this.formatJsonObjectVariableAndAddToResult(variableUpdateDto, resultList);
                continue;
            }
            ProcessVariableDto processVariableDto = this.createSkeletonVariableDto(variableUpdateDto);
            processVariableDto.setId(variableUpdateDto.getId());
            processVariableDto.setName(variableUpdateDto.getName());
            processVariableDto.setType(variableUpdateDto.getType());
            processVariableDto.setValue(Collections.singletonList(variableUpdateDto.getValue()));
            resultList.add(processVariableDto);
        }
        return resultList;
    }

    public List<ProcessVariableDto> convertToProcessVariableDtosSkippingObjectVariables(List<ProcessVariableUpdateDto> variables) {
        return variables.stream().filter(variable -> !this.isNonNullNativeJsonVariable((ProcessVariableUpdateDto)variable) && !this.isNonNullObjectVariable((ProcessVariableUpdateDto)variable)).map(variable -> {
            ProcessVariableDto variableDto = this.createSkeletonVariableDto((ProcessVariableUpdateDto)variable);
            variableDto.setId(variable.getId());
            variableDto.setName(variable.getName());
            variableDto.setType(variable.getType());
            variableDto.setValue(Collections.singletonList(variable.getValue()));
            return variableDto;
        }).toList();
    }

    private void formatJsonObjectVariableAndAddToResult(ProcessVariableUpdateDto variableUpdate, List<ProcessVariableDto> resultList) {
        try {
            Object jsonObject = this.objectMapper.readValue(variableUpdate.getValue(), Object.class);
            if (this.isPrimitiveOrListOfPrimitives(jsonObject)) {
                return;
            }
            ProcessVariableDto processVariableDto = this.createSkeletonVariableDto(variableUpdate);
            processVariableDto.setId(variableUpdate.getId());
            processVariableDto.setName(variableUpdate.getName());
            processVariableDto.setType(VariableType.OBJECT.getId());
            processVariableDto.setValue(Collections.singletonList(this.objectMapper.writeValueAsString(jsonObject)));
            resultList.add(processVariableDto);
        }
        catch (JsonProcessingException e) {
            LOG.error("Error while formatting json object variable with name '{}'.", (Object)variableUpdate.getName(), (Object)e);
        }
    }

    private boolean isPrimitiveOrListOfPrimitives(Object jsonObject) {
        if (jsonObject instanceof ArrayList && !((ArrayList)jsonObject).isEmpty()) {
            return ((ArrayList)jsonObject).stream().filter(Objects::nonNull).findFirst().map(item -> item instanceof String || item instanceof Number || item instanceof Boolean).orElse(true);
        }
        return jsonObject instanceof String || jsonObject instanceof Number || jsonObject instanceof Boolean;
    }

    private void flattenJsonObjectVariableAndAddToResult(ProcessVariableUpdateDto variable, List<ProcessVariableDto> resultList) {
        try {
            new JsonFlattener((JsonCore)new JacksonJsonCore(this.objectMapper), variable.getValue()).withFlattenMode(FlattenMode.KEEP_ARRAYS).flattenAsMap().entrySet().stream().map(e -> this.mapToFlattenedVariable((String)e.getKey(), e.getValue(), variable)).forEach(resultList::addAll);
        }
        catch (Exception exception) {
            LOG.error("Error while flattening json object variable with name '{}'.", (Object)variable.getName(), (Object)exception);
        }
    }

    private List<ProcessVariableDto> mapToFlattenedVariable(String name, Object value, ProcessVariableUpdateDto origin) {
        if (value == null || String.valueOf(value).isEmpty() || this.isEmptyListVariable(value)) {
            LOG.debug("Variable attribute '{}' of '{}' is null or empty and won't be imported", (Object)name, (Object)origin.getName());
            return Collections.emptyList();
        }
        ArrayList<ProcessVariableDto> resultList = new ArrayList<ProcessVariableDto>();
        ProcessVariableDto newVariable = this.createSkeletonVariableDto(origin);
        this.addNameToSkeletonVariable(name, newVariable, origin);
        if (value instanceof JsonifyArrayList) {
            newVariable.setName(String.join((CharSequence)".", newVariable.getName(), LIST_SIZE_VARIABLE_SUFFIX));
            newVariable.setType(VariableType.LONG.getId());
            newVariable.setValue(Collections.singletonList(String.valueOf(((JsonifyArrayList)value).size())));
            this.addVariableForListProperty(name, value, origin, resultList);
        } else if (value instanceof String) {
            this.parseStringOrDateVariableAndSet(value, Collections.singletonList(value), newVariable);
        } else if (value instanceof Boolean) {
            this.parseBooleanVariableAndSet(Collections.singletonList(value), newVariable);
        } else if (value instanceof Number) {
            this.parseNumberVariableAndSet(Collections.singletonList(value), newVariable);
        } else {
            LOG.debug("Variable attribute '{}' of '{}' with type {} is not supported and won't be imported.", new Object[]{name, origin.getName(), value.getClass().getSimpleName()});
            return Collections.emptyList();
        }
        this.addIdToSkeletonVariable(name, newVariable, origin);
        resultList.add(newVariable);
        return resultList;
    }

    private void addVariableForListProperty(String name, Object value, ProcessVariableUpdateDto origin, List<ProcessVariableDto> resultList) {
        ArrayList originList = (ArrayList)value;
        if (originList.isEmpty()) {
            return;
        }
        ProcessVariableDto newListVar = this.createSkeletonVariableDto(origin);
        this.addNameToSkeletonVariable(name, newListVar, origin);
        this.addIdToSkeletonVariable(name, newListVar, origin);
        this.determineListVariableType(name, origin, originList).ifPresent(type -> {
            switch (type) {
                case STRING: {
                    this.parseStringVariableAndSet(originList, newListVar);
                    break;
                }
                case DATE: {
                    this.parseDateVariableAndSet(originList, newListVar);
                    break;
                }
                case DOUBLE: {
                    this.parseNumberVariableAndSet(originList, newListVar);
                    break;
                }
                case BOOLEAN: {
                    this.parseBooleanVariableAndSet(originList, newListVar);
                    break;
                }
            }
        });
        resultList.add(newListVar);
    }

    private Optional<VariableType> determineListVariableType(String name, ProcessVariableUpdateDto origin, List<Object> listVariable) {
        return listVariable.stream().filter(Objects::nonNull).findFirst().map(nonNullItem -> {
            if (nonNullItem instanceof String) {
                Optional<OffsetDateTime> optDate = this.parsePossibleDate(String.valueOf(nonNullItem));
                if (optDate.isPresent()) {
                    return VariableType.DATE;
                }
                return VariableType.STRING;
            }
            if (nonNullItem instanceof Boolean) {
                return VariableType.BOOLEAN;
            }
            if (nonNullItem instanceof Number) {
                return VariableType.DOUBLE;
            }
            LOG.debug("List variable attribute '{}' of '{}' with type {} is not supported and won't be imported.", new Object[]{name, origin.getName(), nonNullItem.getClass().getSimpleName()});
            return null;
        });
    }

    private ProcessVariableDto createSkeletonVariableDto(ProcessVariableUpdateDto origin) {
        ProcessVariableDto processVariableDto = new ProcessVariableDto();
        processVariableDto.setEngineAlias(origin.getEngineAlias());
        processVariableDto.setProcessDefinitionId(origin.getProcessDefinitionId());
        processVariableDto.setProcessDefinitionKey(origin.getProcessDefinitionKey());
        processVariableDto.setProcessInstanceId(origin.getProcessInstanceId());
        processVariableDto.setVersion(origin.getVersion());
        processVariableDto.setTimestamp(origin.getTimestamp());
        processVariableDto.setTenantId(origin.getTenantId());
        return processVariableDto;
    }

    private void addNameToSkeletonVariable(String propertyName, ProcessVariableDto newVariable, ProcessVariableUpdateDto origin) {
        if ("root".equals(propertyName)) {
            newVariable.setName(origin.getName());
        } else {
            newVariable.setName(String.join((CharSequence)".", origin.getName(), propertyName));
        }
    }

    private void addIdToSkeletonVariable(String propertyName, ProcessVariableDto newVariable, ProcessVariableUpdateDto origin) {
        if ("root".equals(propertyName) && !newVariable.getName().contains(LIST_SIZE_VARIABLE_SUFFIX)) {
            newVariable.setId(origin.getId());
        } else {
            newVariable.setId(origin.getId() + "_" + newVariable.getName());
        }
    }

    private Optional<OffsetDateTime> parsePossibleDate(String dateAsString) {
        try {
            return Optional.of(DateParserUtils.parseOffsetDateTime((String)dateAsString));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private void parseStringOrDateVariableAndSet(Object firstValue, List<Object> valueList, ProcessVariableDto newVariable) {
        Optional<OffsetDateTime> optDate = this.parsePossibleDate(String.valueOf(firstValue));
        if (optDate.isPresent()) {
            this.parseDateVariableAndSet(valueList, newVariable);
        } else {
            this.parseStringVariableAndSet(valueList, newVariable);
        }
    }

    private void parseStringVariableAndSet(List<Object> valueList, ProcessVariableDto newVariable) {
        newVariable.setType(VariableType.STRING.getId());
        newVariable.setValue(valueList.stream().map(String::valueOf).collect(Collectors.toList()));
    }

    private void parseDateVariableAndSet(List<Object> valueList, ProcessVariableDto newVariable) {
        newVariable.setType(VariableType.DATE.getId());
        newVariable.setValue(valueList.stream().map(item -> this.parsePossibleDate(String.valueOf(item)).orElse(null)).filter(Objects::nonNull).map(OPTIMIZE_DATE_TIME_FORMATTER::format).collect(Collectors.toList()));
    }

    private void parseBooleanVariableAndSet(List<Object> valueList, ProcessVariableDto newVariable) {
        newVariable.setType(VariableType.BOOLEAN.getId());
        newVariable.setValue(valueList.stream().map(item -> ((Boolean)item).toString()).collect(Collectors.toList()));
    }

    private void parseNumberVariableAndSet(List<Object> valueList, ProcessVariableDto newVariable) {
        newVariable.setType(VariableType.DOUBLE.getId());
        newVariable.setValue(valueList.stream().map(item -> String.valueOf(((Number)item).doubleValue())).collect(Collectors.toList()));
    }

    private boolean isNonNullNativeJsonVariable(ProcessVariableUpdateDto originVariable) {
        return originVariable.getValue() != null && "Json".equalsIgnoreCase(originVariable.getType());
    }

    private boolean isNonNullObjectVariable(ProcessVariableUpdateDto originVariable) {
        return originVariable.getValue() != null && "Object".equalsIgnoreCase(originVariable.getType());
    }

    private boolean isEmptyListVariable(Object value) {
        return value instanceof JsonifyArrayList && ((JsonifyArrayList)value).stream().allMatch(Objects::isNull);
    }

    private boolean isSupportedSerializationFormat(ProcessVariableUpdateDto originVariable) {
        if (this.isNonNullNativeJsonVariable(originVariable)) {
            return true;
        }
        Optional<String> serializationDataFormat = Optional.ofNullable(String.valueOf(originVariable.getValueInfo().get("serializationDataFormat")));
        if (serializationDataFormat.stream().anyMatch("application/json"::equals)) {
            return true;
        }
        LOG.warn("Object variable '{}' will not be imported due to unsupported serializationDataFormat: {}. Object variables must have serializationDataFormat application/json.", (Object)originVariable.getName(), (Object)serializationDataFormat.orElse("no format specified"));
        return false;
    }
}

