/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing;

import io.camunda.optimize.dto.optimize.datasource.DataSourceDto;
import io.camunda.optimize.dto.optimize.datasource.ZeebeDataSourceDto;
import io.camunda.optimize.dto.optimize.index.PositionBasedImportIndexDto;
import io.camunda.optimize.service.db.reader.importindex.PositionBasedImportIndexReader;
import io.camunda.optimize.service.importing.ZeebeImportIndexHandler;
import io.camunda.optimize.service.importing.ingested.handler.ExternalVariableUpdateImportIndexHandler;
import io.camunda.optimize.service.importing.page.PositionBasedImportPage;
import jakarta.annotation.PostConstruct;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
public abstract class PositionBasedImportIndexHandler
implements ZeebeImportIndexHandler<PositionBasedImportPage, PositionBasedImportIndexDto> {
    private static final Logger LOG = LoggerFactory.getLogger(PositionBasedImportIndexHandler.class);
    protected ZeebeDataSourceDto dataSource;
    private OffsetDateTime lastImportExecutionTimestamp = ExternalVariableUpdateImportIndexHandler.BEGINNING_OF_TIME;
    private OffsetDateTime timestampOfLastPersistedEntity = ExternalVariableUpdateImportIndexHandler.BEGINNING_OF_TIME;
    private long persistedPositionOfLastEntity = 0L;
    private long persistedSequenceOfLastEntity = 0L;
    private long pendingPositionOfLastEntity = 0L;
    private long pendingSequenceOfLastEntity = 0L;
    private boolean hasSeenSequenceField = false;
    @Autowired
    private PositionBasedImportIndexReader positionBasedImportIndexReader;

    @PostConstruct
    protected void init() {
        Optional<PositionBasedImportIndexDto> dto = this.positionBasedImportIndexReader.getImportIndex(this.getDatabaseDocID(), this.dataSource);
        if (dto.isPresent()) {
            PositionBasedImportIndexDto loadedImportIndex = dto.get();
            this.updateLastPersistedEntityPositionAndSequence(loadedImportIndex.getPositionOfLastEntity(), loadedImportIndex.getSequenceOfLastEntity());
            this.updatePendingLastEntityPositionAndSequence(loadedImportIndex.getPositionOfLastEntity(), loadedImportIndex.getSequenceOfLastEntity());
            this.updateLastImportExecutionTimestamp(loadedImportIndex.getLastImportExecutionTimestamp());
            this.updateTimestampOfLastPersistedEntity(loadedImportIndex.getTimestampOfLastEntity());
            this.hasSeenSequenceField = loadedImportIndex.isHasSeenSequenceField();
        }
    }

    @Override
    public ZeebeDataSourceDto getDataSource() {
        return this.dataSource;
    }

    @Override
    public PositionBasedImportPage getNextPage() {
        PositionBasedImportPage page = new PositionBasedImportPage();
        page.setPosition(this.pendingPositionOfLastEntity);
        page.setSequence(this.pendingSequenceOfLastEntity);
        page.setHasSeenSequenceField(this.hasSeenSequenceField);
        return page;
    }

    @Override
    public PositionBasedImportIndexDto getIndexStateDto() {
        PositionBasedImportIndexDto indexToStore = new PositionBasedImportIndexDto();
        indexToStore.setDataSource((DataSourceDto)this.dataSource);
        indexToStore.setLastImportExecutionTimestamp(this.lastImportExecutionTimestamp);
        indexToStore.setPositionOfLastEntity(this.persistedPositionOfLastEntity);
        indexToStore.setSequenceOfLastEntity(this.persistedSequenceOfLastEntity);
        indexToStore.setTimestampOfLastEntity(this.timestampOfLastPersistedEntity);
        indexToStore.setHasSeenSequenceField(this.hasSeenSequenceField);
        indexToStore.setDbTypeIndexRefersTo(this.getDatabaseDocID());
        return indexToStore;
    }

    @Override
    public void resetImportIndex() {
        this.lastImportExecutionTimestamp = ExternalVariableUpdateImportIndexHandler.BEGINNING_OF_TIME;
        this.timestampOfLastPersistedEntity = ExternalVariableUpdateImportIndexHandler.BEGINNING_OF_TIME;
        this.persistedPositionOfLastEntity = 0L;
        this.persistedSequenceOfLastEntity = 0L;
        this.pendingPositionOfLastEntity = 0L;
        this.pendingSequenceOfLastEntity = 0L;
        this.hasSeenSequenceField = false;
    }

    protected abstract String getDatabaseDocID();

    public void updateLastPersistedEntityPositionAndSequence(long position, long sequence) {
        this.persistedPositionOfLastEntity = position;
        this.persistedSequenceOfLastEntity = sequence;
        if (!this.hasSeenSequenceField && this.persistedSequenceOfLastEntity > 0L) {
            this.hasSeenSequenceField = true;
        }
    }

    public void updatePendingLastEntityPositionAndSequence(long position, long sequence) {
        this.pendingPositionOfLastEntity = position;
        this.pendingSequenceOfLastEntity = sequence;
        if (!this.hasSeenSequenceField && this.pendingSequenceOfLastEntity > 0L) {
            LOG.info("First Zeebe record with sequence field for import type {} has been imported. Zeebe records will now be fetched based on sequence.", (Object)this.getDatabaseDocID());
            this.hasSeenSequenceField = true;
        }
    }

    public void updateLastImportExecutionTimestamp(OffsetDateTime timestamp) {
        this.lastImportExecutionTimestamp = timestamp;
    }

    public void updateTimestampOfLastPersistedEntity(OffsetDateTime timestamp) {
        this.timestampOfLastPersistedEntity = timestamp;
    }

    public OffsetDateTime getLastImportExecutionTimestamp() {
        return this.lastImportExecutionTimestamp;
    }

    public OffsetDateTime getTimestampOfLastPersistedEntity() {
        return this.timestampOfLastPersistedEntity;
    }

    public long getPersistedPositionOfLastEntity() {
        return this.persistedPositionOfLastEntity;
    }

    public long getPersistedSequenceOfLastEntity() {
        return this.persistedSequenceOfLastEntity;
    }

    public long getPendingPositionOfLastEntity() {
        return this.pendingPositionOfLastEntity;
    }

    public long getPendingSequenceOfLastEntity() {
        return this.pendingSequenceOfLastEntity;
    }

    public boolean isHasSeenSequenceField() {
        return this.hasSeenSequenceField;
    }

    public PositionBasedImportIndexReader getPositionBasedImportIndexReader() {
        return this.positionBasedImportIndexReader;
    }
}

