/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing;

import io.camunda.optimize.service.importing.ImportIndexHandler;
import io.camunda.optimize.service.importing.PositionBasedImportIndexHandler;
import io.camunda.optimize.service.importing.ZeebeImportIndexHandler;
import io.camunda.optimize.service.importing.ingested.handler.ExternalVariableUpdateImportIndexHandler;
import io.camunda.optimize.service.importing.ingested.handler.IngestedImportIndexHandlerProvider;
import io.camunda.optimize.service.importing.zeebe.handler.ZeebeImportIndexHandlerProvider;
import io.camunda.optimize.service.importing.zeebe.handler.ZeebeIncidentImportIndexHandler;
import io.camunda.optimize.service.importing.zeebe.handler.ZeebeProcessDefinitionImportIndexHandler;
import io.camunda.optimize.service.importing.zeebe.handler.ZeebeProcessInstanceImportIndexHandler;
import io.camunda.optimize.service.importing.zeebe.handler.ZeebeUserTaskImportIndexHandler;
import io.camunda.optimize.service.importing.zeebe.handler.ZeebeVariableImportIndexHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class ImportIndexHandlerRegistry {
    private IngestedImportIndexHandlerProvider ingestedImportIndexHandlerProvider = null;
    private Map<Integer, ZeebeImportIndexHandlerProvider> zeebeImportIndexHandlerProviderMap = new HashMap<Integer, ZeebeImportIndexHandlerProvider>();

    public void register(IngestedImportIndexHandlerProvider ingestedImportIndexHandlerProvider) {
        this.ingestedImportIndexHandlerProvider = ingestedImportIndexHandlerProvider;
    }

    public void register(int partitionId, ZeebeImportIndexHandlerProvider zeebeImportIndexHandlerProvider) {
        this.zeebeImportIndexHandlerProviderMap.put(partitionId, zeebeImportIndexHandlerProvider);
    }

    public List<PositionBasedImportIndexHandler> getPositionBasedHandlers(Integer partitionId) {
        return Optional.ofNullable(this.zeebeImportIndexHandlerProviderMap.get(partitionId)).map(ZeebeImportIndexHandlerProvider::getPositionBasedImportHandlers).orElse(Collections.emptyList());
    }

    public Collection<ImportIndexHandler<?, ?>> getAllIngestedImportHandlers() {
        return this.ingestedImportIndexHandlerProvider.getAllHandlers();
    }

    public ZeebeProcessDefinitionImportIndexHandler getZeebeProcessDefinitionImportIndexHandler(Integer partitionId) {
        return this.getZeebeImportIndexHandler(partitionId, ZeebeProcessDefinitionImportIndexHandler.class);
    }

    public ZeebeProcessInstanceImportIndexHandler getZeebeProcessInstanceImportIndexHandler(Integer partitionId) {
        return this.getZeebeImportIndexHandler(partitionId, ZeebeProcessInstanceImportIndexHandler.class);
    }

    public ZeebeIncidentImportIndexHandler getZeebeIncidentImportIndexHandler(Integer partitionId) {
        return this.getZeebeImportIndexHandler(partitionId, ZeebeIncidentImportIndexHandler.class);
    }

    public ZeebeVariableImportIndexHandler getZeebeVariableImportIndexHandler(Integer partitionId) {
        return this.getZeebeImportIndexHandler(partitionId, ZeebeVariableImportIndexHandler.class);
    }

    public ZeebeUserTaskImportIndexHandler getZeebeUserTaskImportIndexHandler(Integer partitionId) {
        return this.getZeebeImportIndexHandler(partitionId, ZeebeUserTaskImportIndexHandler.class);
    }

    public ExternalVariableUpdateImportIndexHandler getExternalVariableUpdateImportIndexHandler() {
        return this.ingestedImportIndexHandlerProvider.getExternalVariableUpdateImportIndexHandler();
    }

    public void reloadConfiguration() {
        this.ingestedImportIndexHandlerProvider = null;
        this.zeebeImportIndexHandlerProviderMap = new HashMap<Integer, ZeebeImportIndexHandlerProvider>();
    }

    private <T extends ZeebeImportIndexHandler> T getZeebeImportIndexHandler(Integer partitionId, Class<T> handlerClass) {
        return (T)((ZeebeImportIndexHandler)Optional.ofNullable(this.zeebeImportIndexHandlerProviderMap.get(partitionId)).map(provider -> provider.getImportIndexHandler(handlerClass)).orElse(null));
    }
}

