/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.importing;

import io.camunda.optimize.dto.optimize.OptimizeDto;
import io.camunda.optimize.service.db.DatabaseClient;
import io.camunda.optimize.service.util.BackoffCalculator;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseImportJob<OPT extends OptimizeDto>
implements Runnable {
    protected final DatabaseClient databaseClient;
    protected List<OPT> newOptimizeEntities = Collections.emptyList();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BackoffCalculator backoffCalculator = new BackoffCalculator(1L, 30L);
    private final Runnable importCompleteCallback;

    protected DatabaseImportJob(Runnable importCompleteCallback, DatabaseClient databaseClient) {
        this.importCompleteCallback = importCompleteCallback;
        this.databaseClient = databaseClient;
    }

    @Override
    public void run() {
        this.executeImport();
    }

    public void setEntitiesToImport(List<OPT> pageOfOptimizeEntities) {
        this.newOptimizeEntities = pageOfOptimizeEntities;
    }

    protected void executeImport() {
        if (!this.newOptimizeEntities.isEmpty()) {
            boolean success = false;
            do {
                try {
                    long persistStart = System.currentTimeMillis();
                    this.persistEntities(this.newOptimizeEntities);
                    long persistEnd = System.currentTimeMillis();
                    this.logger.debug("Executing import to database took [{}] ms", (Object)(persistEnd - persistStart));
                    success = true;
                }
                catch (Exception e) {
                    this.logger.error("Error while executing import to database", (Throwable)e);
                    long sleepTime = this.backoffCalculator.calculateSleepTime();
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException exception) {
                        Thread.currentThread().interrupt();
                    }
                }
            } while (!success);
        } else {
            this.logger.debug("Import job with no new entities, import bulk execution is skipped.");
        }
        this.importCompleteCallback.run();
    }

    protected abstract void persistEntities(List<OPT> var1) throws Exception;
}

