/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.identity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.util.BpmnModelUtil;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class CollapsedSubprocessNodesService {
    public static final int MAX_CACHE_SIZE = 10;
    public static final int CACHE_EXPIRY_MINS = 10;
    private final Cache<String, Set<String>> collapsedSubprocessNodesCache = CacheBuilder.newBuilder().maximumSize(10L).expireAfterAccess(10L, TimeUnit.MINUTES).build();

    public Set<String> getCollapsedSubprocessNodeIdsForReport(ProcessReportDataDto reportDataDto) {
        String cacheKey = CollapsedSubprocessNodesService.buildCacheEntryKey(reportDataDto);
        Set cachedNodes = (Set)this.collapsedSubprocessNodesCache.getIfPresent((Object)cacheKey);
        if (cachedNodes != null) {
            return cachedNodes;
        }
        Set<String> collapsedSubprocessNodeIds = BpmnModelUtil.getCollapsedSubprocessElementIds(reportDataDto.getConfiguration().getXml());
        this.collapsedSubprocessNodesCache.put((Object)cacheKey, collapsedSubprocessNodeIds);
        return collapsedSubprocessNodeIds;
    }

    private static String buildCacheEntryKey(ProcessReportDataDto reportDataDto) {
        return reportDataDto.getDefinitionKey() + "_v" + String.valueOf(reportDataDto.getDefinitionVersions());
    }
}

