/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.identity;

import io.camunda.optimize.dto.optimize.GroupDto;
import io.camunda.optimize.dto.optimize.IdentityDto;
import io.camunda.optimize.dto.optimize.IdentityWithMetadataResponseDto;
import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.dto.optimize.cloud.CloudUserDto;
import io.camunda.optimize.dto.optimize.query.IdentitySearchResultResponseDto;
import io.camunda.optimize.rest.cloud.CCSaaSUserCache;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSaaSCondition;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSaaSCondition.class})
public class CCSaaSIdentityService
extends AbstractIdentityService {
    private static final Logger LOG = LoggerFactory.getLogger(CCSaaSIdentityService.class);
    private final CCSaaSUserCache usersCache;

    public CCSaaSIdentityService(ConfigurationService configurationService, CCSaaSUserCache usersCache) {
        super(configurationService);
        this.usersCache = usersCache;
    }

    @Override
    public Optional<UserDto> getUserById(String userId) {
        return this.usersCache.getUserById(userId).map(this::mapToUserDto);
    }

    @Override
    public Optional<UserDto> getCurrentUserById(String userId, HttpServletRequest request) {
        return this.getUserById(userId);
    }

    @Override
    public Optional<GroupDto> getGroupById(String groupId) {
        return Optional.empty();
    }

    @Override
    public List<GroupDto> getAllGroupsOfUser(String userId) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUserAuthorizedToAccessIdentity(String userId, IdentityDto identity) {
        return true;
    }

    @Override
    public IdentitySearchResultResponseDto searchForIdentitiesAsUser(String userId, String searchString, int maxResults, boolean excludeUserGroups) {
        try {
            if (StringUtils.isBlank((CharSequence)searchString)) {
                return new IdentitySearchResultResponseDto(this.usersCache.getAllUsers().stream().limit(maxResults).map(this::mapToUserDto).collect(Collectors.toList()));
            }
            return new IdentitySearchResultResponseDto(this.usersCache.getAllUsers().stream().filter(cloudUser -> cloudUser.getSearchableDtoFields().stream().map(Supplier::get).anyMatch(field -> StringUtils.isNotBlank((CharSequence)field) && StringUtils.containsIgnoreCase((CharSequence)field, (CharSequence)searchString))).limit(maxResults).map(this::mapToUserDto).collect(Collectors.toList()));
        }
        catch (OptimizeRuntimeException e) {
            LOG.warn("Failed retrieving users.", (Throwable)e);
            return new IdentitySearchResultResponseDto(Collections.emptyList());
        }
    }

    @Override
    public List<IdentityWithMetadataResponseDto> getUsersById(Set<String> userIds) {
        return this.usersCache.getUsersById(userIds).stream().map(this::mapToUserDto).map(IdentityWithMetadataResponseDto.class::cast).toList();
    }

    @Override
    public List<IdentityWithMetadataResponseDto> getGroupsById(Set<String> groupIds) {
        return Collections.emptyList();
    }

    public List<UserDto> getUsersByEmail(Set<String> emails) {
        try {
            return this.usersCache.getAllUsers().stream().filter(cloudUser -> StringUtils.containsAnyIgnoreCase((CharSequence)cloudUser.getEmail(), (CharSequence[])emails.toArray(new String[0]))).map(this::mapToUserDto).toList();
        }
        catch (OptimizeRuntimeException e) {
            LOG.warn("Failed retrieving users.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @NotNull
    private UserDto mapToUserDto(CloudUserDto cloudUser) {
        return new UserDto(cloudUser.getUserId(), cloudUser.getName(), cloudUser.getEmail(), cloudUser.getRoles());
    }
}

