/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.identity;

import io.camunda.optimize.dto.optimize.GroupDto;
import io.camunda.optimize.dto.optimize.IdentityDto;
import io.camunda.optimize.dto.optimize.IdentityWithMetadataResponseDto;
import io.camunda.optimize.dto.optimize.UserDto;
import io.camunda.optimize.dto.optimize.query.IdentitySearchResultResponseDto;
import io.camunda.optimize.service.identity.AbstractIdentityService;
import io.camunda.optimize.service.identity.CCSMUserCache;
import io.camunda.optimize.service.security.CCSMTokenService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.CCSMCondition;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={CCSMCondition.class})
public class CCSMIdentityService
extends AbstractIdentityService {
    private static final Logger LOG = LoggerFactory.getLogger(CCSMIdentityService.class);
    private final CCSMTokenService ccsmTokenService;
    private final CCSMUserCache userCache;

    public CCSMIdentityService(ConfigurationService configurationService, CCSMTokenService ccsmTokenService, CCSMUserCache userCache) {
        super(configurationService);
        this.ccsmTokenService = ccsmTokenService;
        this.userCache = userCache;
    }

    @Override
    public Optional<UserDto> getUserById(String userId) {
        return this.userCache.getUserById(userId);
    }

    @Override
    public Optional<UserDto> getCurrentUserById(String userId, HttpServletRequest request) {
        return Optional.ofNullable(request.getCookies()).flatMap(cookies -> {
            Cookie authorizationCookie = Arrays.stream(request.getCookies()).filter(cookie -> "X-Optimize-Authorization".equals(cookie.getName())).findAny().orElse(null);
            return Optional.ofNullable(authorizationCookie).map(cookie -> this.ccsmTokenService.getUserInfoFromToken(userId, authorizationCookie.getValue()));
        });
    }

    @Override
    public Optional<GroupDto> getGroupById(String groupId) {
        return Optional.empty();
    }

    @Override
    public List<GroupDto> getAllGroupsOfUser(String userId) {
        return Collections.emptyList();
    }

    @Override
    public boolean isUserAuthorizedToAccessIdentity(String userId, IdentityDto identity) {
        return true;
    }

    @Override
    public IdentitySearchResultResponseDto searchForIdentitiesAsUser(String userId, String searchString, int maxResults, boolean excludeUserGroups) {
        return new IdentitySearchResultResponseDto(this.userCache.searchForIdentityUsingSearchTerm(searchString, maxResults).stream().map(IdentityWithMetadataResponseDto.class::cast).toList());
    }

    @Override
    public List<IdentityWithMetadataResponseDto> getUsersById(Set<String> userIds) {
        return this.userCache.getUsersById(userIds).stream().map(IdentityWithMetadataResponseDto.class::cast).toList();
    }

    @Override
    public List<IdentityWithMetadataResponseDto> getGroupsById(Set<String> groupIds) {
        return Collections.emptyList();
    }

    public List<UserDto> getUsersByEmail(Set<String> emails) {
        return this.userCache.searchForUsersUsingEmails(emails).stream().map(UserDto.class::cast).toList();
    }
}

