/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.export;

import io.camunda.optimize.dto.optimize.query.report.AuthorizedReportEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.report.AuthorizationCheckReportEvaluationHandler;
import io.camunda.optimize.service.db.report.ReportEvaluationInfo;
import io.camunda.optimize.service.export.CSVUtils;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CsvExportService {
    public static final Integer DEFAULT_RECORD_LIMIT = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(CsvExportService.class);
    private final AuthorizationCheckReportEvaluationHandler reportEvaluationHandler;
    private final ConfigurationService configurationService;

    public CsvExportService(AuthorizationCheckReportEvaluationHandler reportEvaluationHandler, ConfigurationService configurationService) {
        this.reportEvaluationHandler = reportEvaluationHandler;
        this.configurationService = configurationService;
    }

    public Optional<byte[]> getCsvBytesForEvaluatedReportResult(String userId, String reportId, ZoneId timezone) {
        LOG.debug("Exporting report with id [{}] as csv.", (Object)reportId);
        try {
            ReportEvaluationInfo evaluationInfo = ReportEvaluationInfo.builder(reportId).userId(userId).timezone(timezone).isCsvExport(true).build();
            AuthorizedReportEvaluationResult reportResult = this.reportEvaluationHandler.evaluateReport(evaluationInfo);
            List resultAsCsv = reportResult.getEvaluationResult().getResultAsCsv(Optional.ofNullable(this.configurationService.getCsvConfiguration().getExportCsvLimit()).orElse(DEFAULT_RECORD_LIMIT), Integer.valueOf(0), timezone);
            return Optional.ofNullable(CSVUtils.mapCsvLinesToCsvBytes(resultAsCsv, this.configurationService.getCsvConfiguration().getExportCsvDelimiter().charValue()));
        }
        catch (NotFoundException e) {
            LOG.debug("Could not find report with id {} to export the result to csv!", (Object)reportId, (Object)e);
            return Optional.empty();
        }
        catch (Exception e) {
            LOG.error("Could not evaluate report with id {} to export the result to csv!", (Object)reportId, (Object)e);
            throw e;
        }
    }

    public byte[] getCsvBytesForEvaluatedReportResult(String userId, ReportDefinitionDto<?> reportDefinition, ZoneId timezone) {
        LOG.debug("Exporting provided report definition as csv.");
        try {
            ReportEvaluationInfo evaluationInfo = ReportEvaluationInfo.builder(reportDefinition).userId(userId).timezone(timezone).isCsvExport(true).build();
            AuthorizedReportEvaluationResult reportResult = this.reportEvaluationHandler.evaluateReport(evaluationInfo);
            List resultAsCsv = reportResult.getEvaluationResult().getResultAsCsv(Optional.ofNullable(this.configurationService.getCsvConfiguration().getExportCsvLimit()).orElse(DEFAULT_RECORD_LIMIT), Integer.valueOf(0), timezone);
            return CSVUtils.mapCsvLinesToCsvBytes(resultAsCsv, this.configurationService.getCsvConfiguration().getExportCsvDelimiter().charValue());
        }
        catch (Exception e) {
            LOG.error("Could not evaluate report to export the result to csv!", (Throwable)e);
            throw e;
        }
    }
}

