/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.export;

import com.opencsv.CSVWriter;
import io.camunda.optimize.dto.optimize.FlowNodeTotalDurationDataDto;
import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.TableColumnDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.InputVariableEntry;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.OutputVariableEntry;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.RawDataDecisionInstanceDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.result.raw.RawDataCountDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.result.raw.RawDataProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.hyper.MapResultEntryDto;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CSVUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CSVUtils.class);

    private CSVUtils() {
    }

    public static byte[] mapCsvLinesToCsvBytes(List<String[]> csvStrings, char csvDelimiter) {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(arrayOutputStream));
        CSVWriter csvWriter = new CSVWriter((Writer)bufferedWriter, csvDelimiter, '\"', '\"', "\r\n");
        byte[] bytes = null;
        try {
            csvWriter.writeAll(csvStrings);
            bufferedWriter.flush();
            bufferedWriter.close();
            arrayOutputStream.flush();
            bytes = arrayOutputStream.toByteArray();
            arrayOutputStream.close();
        }
        catch (Exception e) {
            LOG.error("can't write CSV to buffer", (Throwable)e);
        }
        return bytes;
    }

    public static <T extends IdResponseDto> List<String[]> mapIdList(List<T> ids) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        result.add(new String[]{"processInstanceId"});
        ids.forEach(idDto -> result.add(new String[]{idDto.getId()}));
        return result;
    }

    public static List<String[]> mapRawProcessReportInstances(List<RawDataProcessInstanceDto> rawData, Integer limit, Integer offset, TableColumnDto tableColumns, boolean includeNewVariables) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        List<String> allCountKeys = CSVUtils.extractAllPrefixedCountKeys();
        List<String> allFlowNodeDurationKeys = CSVUtils.extractAllPrefixedFlowNodeKeys(rawData);
        List<String> allVariableKeys = CSVUtils.extractAllPrefixedVariableKeys(rawData);
        tableColumns.setIncludeNewVariables(includeNewVariables);
        tableColumns.addDtoColumns(CSVUtils.extractAllProcessInstanceDtoFieldKeys());
        tableColumns.addCountColumns(allCountKeys);
        tableColumns.addNewAndRemoveUnexpectedFlowNodeDurationColumns(allFlowNodeDurationKeys);
        tableColumns.addNewAndRemoveUnexpectedVariableColumns(allVariableKeys);
        List allIncludedKeysInOrder = tableColumns.getIncludedColumns();
        result.add(allIncludedKeysInOrder.toArray(new String[0]));
        int currentPosition = 0;
        for (RawDataProcessInstanceDto instanceDto : rawData) {
            boolean limitNotExceeded = CSVUtils.isLimitNotExceeded(limit, result);
            if (offset == null && limitNotExceeded || CSVUtils.isOffsetPassed(offset, currentPosition) && limitNotExceeded) {
                String[] dataLine = new String[allIncludedKeysInOrder.size()];
                for (int i = 0; i < dataLine.length; ++i) {
                    String currentKey = (String)allIncludedKeysInOrder.get(i);
                    Optional<String> columnValue = allVariableKeys.contains(currentKey) ? CSVUtils.getVariableValue(instanceDto, currentKey) : (allFlowNodeDurationKeys.contains(currentKey) ? CSVUtils.getFlowNodeDurationValue(instanceDto, currentKey) : (allCountKeys.contains(currentKey) ? CSVUtils.getCountValue(instanceDto, currentKey) : CSVUtils.getDtoFieldValue(instanceDto, RawDataProcessInstanceDto.class, currentKey)));
                    dataLine[i] = columnValue.orElse(null);
                }
                result.add(dataLine);
            }
            ++currentPosition;
        }
        return result;
    }

    public static List<String[]> mapRawDecisionReportInstances(List<RawDataDecisionInstanceDto> rawData, Integer limit, Integer offset, TableColumnDto tableColumns) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        ArrayList<String> allVariableKeys = new ArrayList<String>();
        List<String> allInputVariableKeys = CSVUtils.extractAllPrefixedDecisionInputKeys(rawData);
        List<String> allOutputVariableKeys = CSVUtils.extractAllPrefixedDecisionOutputKeys(rawData);
        allVariableKeys.addAll(allInputVariableKeys);
        allVariableKeys.addAll(allOutputVariableKeys);
        tableColumns.addDtoColumns(CSVUtils.extractAllDecisionInstanceDtoFieldKeys());
        tableColumns.addNewAndRemoveUnexpectedVariableColumns(allVariableKeys);
        List allIncludedKeysInOrder = tableColumns.getIncludedColumns();
        result.add(allIncludedKeysInOrder.toArray(new String[0]));
        int currentPosition = 0;
        for (RawDataDecisionInstanceDto instanceDto : rawData) {
            boolean limitNotExceeded = CSVUtils.isLimitNotExceeded(limit, result);
            if (offset == null && limitNotExceeded || CSVUtils.isOffsetPassed(offset, currentPosition) && limitNotExceeded) {
                String[] dataLine = new String[allIncludedKeysInOrder.size()];
                for (int i = 0; i < dataLine.length; ++i) {
                    String currentKey = (String)allIncludedKeysInOrder.get(i);
                    Optional<String> optionalValue = allInputVariableKeys.contains(currentKey) ? CSVUtils.getInputVariableValue(instanceDto, currentKey) : (allOutputVariableKeys.contains(currentKey) ? CSVUtils.getOutputVariableValue(instanceDto, currentKey) : CSVUtils.getDtoFieldValue(instanceDto, RawDataDecisionInstanceDto.class, currentKey));
                    dataLine[i] = optionalValue.orElse(null);
                }
                result.add(dataLine);
            }
            ++currentPosition;
        }
        return result;
    }

    public static List<String[]> map(List<MapResultEntryDto> values, Integer limit, Integer offset) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        int currentPosition = 0;
        for (MapResultEntryDto value : values) {
            boolean limitNotExceeded = CSVUtils.isLimitNotExceeded(limit, result);
            boolean offsetPassed = CSVUtils.isOffsetPassed(offset, currentPosition);
            if (offset == null && limitNotExceeded || offsetPassed && limitNotExceeded) {
                String[] line = new String[]{value.getLabel(), Optional.ofNullable(value.getValue()).map(Object::toString).orElse("")};
                result.add(line);
            }
            ++currentPosition;
        }
        return result;
    }

    public static String mapAggregationType(AggregationDto aggregationDto) {
        switch (aggregationDto.getType()) {
            case AVERAGE: {
                return "average";
            }
            case MIN: {
                return "minimum";
            }
            case MAX: {
                return "maximum";
            }
            case SUM: {
                return "sum";
            }
            case PERCENTILE: {
                return "p" + aggregationDto.getValue();
            }
        }
        throw new IllegalStateException("Uncovered type: " + aggregationDto.getValue());
    }

    public static List<String> extractAllDecisionInstanceDtoFieldKeys() {
        return Arrays.stream(RawDataDecisionInstanceDto.Fields.values()).map(Enum::name).collect(Collectors.toList());
    }

    public static List<String> extractAllProcessInstanceDtoFieldKeys() {
        return Arrays.stream(RawDataProcessInstanceDto.Fields.values()).map(Enum::name).collect(Collectors.toList());
    }

    private static String stripOffPrefix(String currentKey, String prefix) {
        return currentKey.replace(prefix, "");
    }

    private static List<String> extractAllPrefixedVariableKeys(List<RawDataProcessInstanceDto> rawData) {
        HashSet variableKeys = new HashSet();
        for (RawDataProcessInstanceDto pi : rawData) {
            Map variables = pi.getVariables();
            if (variables == null) continue;
            variables.entrySet().stream().filter(entry -> !"<<OBJECT_VARIABLE_VALUE>>".equals(entry.getValue())).map(Map.Entry::getKey).forEach(variableKeys::add);
        }
        return variableKeys.stream().map(key -> "variable:" + key).collect(Collectors.toList());
    }

    public static List<String> extractAllPrefixedFlowNodeKeys(List<RawDataProcessInstanceDto> rawData) {
        ArrayList<String> flowNodeKeys = new ArrayList<String>();
        for (RawDataProcessInstanceDto currentInstanceDataDto : rawData) {
            Optional<Map> flowNodeDurations = Optional.ofNullable(currentInstanceDataDto.getFlowNodeDurations());
            flowNodeDurations.ifPresent(stringFlowNodeTotalDurationDataDtoMap -> stringFlowNodeTotalDurationDataDtoMap.keySet().stream().map(flowNodeTotalDurationDataDto -> "dur:" + flowNodeTotalDurationDataDto).forEach(flowNodeKeys::add));
        }
        return flowNodeKeys;
    }

    public static List<String> extractAllPrefixedCountKeys() {
        return List.of(CSVUtils.addCountPrefix(RawDataCountDto.Fields.incidents), CSVUtils.addCountPrefix(RawDataCountDto.Fields.openIncidents), CSVUtils.addCountPrefix(RawDataCountDto.Fields.userTasks));
    }

    private static List<String> extractAllPrefixedDecisionInputKeys(List<RawDataDecisionInstanceDto> rawData) {
        HashSet inputKeys = new HashSet();
        for (RawDataDecisionInstanceDto pi : rawData) {
            if (pi.getInputVariables() == null) continue;
            inputKeys.addAll(pi.getInputVariables().keySet());
        }
        return inputKeys.stream().map(key -> "input:" + key).collect(Collectors.toList());
    }

    private static List<String> extractAllPrefixedDecisionOutputKeys(List<RawDataDecisionInstanceDto> rawData) {
        HashSet outputKeys = new HashSet();
        for (RawDataDecisionInstanceDto di : rawData) {
            if (di.getOutputVariables() == null) continue;
            outputKeys.addAll(di.getOutputVariables().keySet());
        }
        return outputKeys.stream().map(key -> "output:" + key).collect(Collectors.toList());
    }

    private static <T> Optional<String> getDtoFieldValue(T instanceDto, Class<T> instanceClass, String fieldKey) {
        try {
            return Optional.of(new PropertyDescriptor(fieldKey, instanceClass)).map(descriptor -> {
                Optional<Object> value = Optional.empty();
                try {
                    value = Optional.ofNullable(descriptor.getReadMethod().invoke(instanceDto, new Object[0]));
                }
                catch (Exception e) {
                    LOG.error("can't read value of field", (Throwable)e);
                }
                return value.map(Object::toString).orElse(null);
            });
        }
        catch (IntrospectionException e) {
            LOG.error("Tried to access RawDataInstanceDto field that did not exist {} on class {}", (Object)fieldKey, instanceClass);
            return Optional.empty();
        }
    }

    private static Optional<String> getVariableValue(RawDataProcessInstanceDto instanceDto, String variableKey) {
        return Optional.ofNullable(instanceDto.getVariables()).map(variables -> variables.get(CSVUtils.stripOffPrefix(variableKey, "variable:"))).filter(variable -> !"<<OBJECT_VARIABLE_VALUE>>".equals(variable)).map(Object::toString);
    }

    private static Optional<String> getFlowNodeDurationValue(RawDataProcessInstanceDto instanceDto, String flowNodeKey) {
        flowNodeKey = flowNodeKey.replace("dur:", "");
        if (instanceDto.getFlowNodeDurations().containsKey(flowNodeKey)) {
            return Optional.of(Long.toString(((FlowNodeTotalDurationDataDto)instanceDto.getFlowNodeDurations().get(flowNodeKey)).getValue()));
        }
        return Optional.empty();
    }

    private static Optional<String> getCountValue(RawDataProcessInstanceDto instanceDto, String flowNodeKey) {
        if (flowNodeKey.equals(CSVUtils.addCountPrefix(RawDataCountDto.Fields.userTasks))) {
            return Optional.of(Long.toString(instanceDto.getCounts().getUserTasks()));
        }
        if (flowNodeKey.equals(CSVUtils.addCountPrefix(RawDataCountDto.Fields.incidents))) {
            return Optional.of(Long.toString(instanceDto.getCounts().getIncidents()));
        }
        if (flowNodeKey.equals(CSVUtils.addCountPrefix(RawDataCountDto.Fields.openIncidents))) {
            return Optional.of(Long.toString(instanceDto.getCounts().getOpenIncidents()));
        }
        return Optional.empty();
    }

    private static String addCountPrefix(RawDataCountDto.Fields openIncidents) {
        return "count:" + String.valueOf(openIncidents);
    }

    private static Optional<String> getOutputVariableValue(RawDataDecisionInstanceDto instanceDto, String inputKey) {
        return Optional.ofNullable(instanceDto.getOutputVariables()).map(outputs -> (OutputVariableEntry)outputs.get(CSVUtils.stripOffPrefix(inputKey, "output:"))).map(OutputVariableEntry::getValues).map(values -> values.stream().map(Object::toString).collect(Collectors.joining(",")));
    }

    private static Optional<String> getInputVariableValue(RawDataDecisionInstanceDto instanceDto, String outputKey) {
        return Optional.ofNullable(instanceDto.getInputVariables()).map(inputs -> (InputVariableEntry)inputs.get(CSVUtils.stripOffPrefix(outputKey, "input:"))).map(InputVariableEntry::getValue).map(Object::toString);
    }

    private static boolean isOffsetPassed(Integer offset, int currentPosition) {
        return offset != null && currentPosition >= offset;
    }

    private static boolean isLimitNotExceeded(Integer limit, List<String[]> result) {
        return limit == null || result.size() <= limit;
    }
}

