/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.entities;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.EntityIdResponseDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.rest.export.ExportEntityType;
import io.camunda.optimize.dto.optimize.rest.export.OptimizeEntityExportDto;
import io.camunda.optimize.dto.optimize.rest.export.dashboard.DashboardDefinitionExportDto;
import io.camunda.optimize.dto.optimize.rest.export.report.CombinedProcessReportDefinitionExportDto;
import io.camunda.optimize.dto.optimize.rest.export.report.ReportDefinitionExportDto;
import io.camunda.optimize.dto.optimize.rest.export.report.SingleProcessReportDefinitionExportDto;
import io.camunda.optimize.service.collection.CollectionService;
import io.camunda.optimize.service.entities.dashboard.DashboardImportService;
import io.camunda.optimize.service.entities.report.ReportImportService;
import io.camunda.optimize.service.exceptions.OptimizeImportFileInvalidException;
import io.camunda.optimize.service.exceptions.OptimizeValidationException;
import io.camunda.optimize.service.security.AuthorizedCollectionService;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.mapper.ObjectMapperFactory;
import io.camunda.optimize.service.util.mapper.OptimizeDateTimeFormatterFactory;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EntityImportService {
    private static final Logger LOG = LoggerFactory.getLogger(EntityImportService.class);
    private final ReportImportService reportImportService;
    private final DashboardImportService dashboardImportService;
    private final AuthorizedCollectionService authorizedCollectionService;
    private final CollectionService collectionService;
    private final ConfigurationService configurationService;

    public EntityImportService(ReportImportService reportImportService, DashboardImportService dashboardImportService, AuthorizedCollectionService authorizedCollectionService, CollectionService collectionService, ConfigurationService configurationService) {
        this.reportImportService = reportImportService;
        this.dashboardImportService = dashboardImportService;
        this.authorizedCollectionService = authorizedCollectionService;
        this.collectionService = collectionService;
        this.configurationService = configurationService;
    }

    public List<EntityIdResponseDto> importEntities(String collectionId, Set<OptimizeEntityExportDto> entitiesToImport) {
        this.validateCompletenessOrFail(entitiesToImport);
        this.validateNoInstantPreviewEntities(entitiesToImport);
        return this.importValidatedEntities(collectionId, entitiesToImport);
    }

    public List<EntityIdResponseDto> importInstantPreviewEntities(String collectionId, Set<OptimizeEntityExportDto> entitiesToImport) {
        this.validateCompletenessOrFail(entitiesToImport);
        return this.importValidatedEntities(collectionId, entitiesToImport);
    }

    private List<EntityIdResponseDto> importValidatedEntities(String collectionId, Set<OptimizeEntityExportDto> entitiesToImport) {
        List<ReportDefinitionExportDto> reportsToImport = this.retrieveAllReportsToImport(entitiesToImport);
        List<DashboardDefinitionExportDto> dashboardsToImport = this.retrieveAllDashboardsToImport(entitiesToImport);
        CollectionDefinitionDto collection = this.getAndValidateCollectionExistsAndIsAccessibleOrFail(null, collectionId);
        this.reportImportService.validateAllReportsOrFail(collection, reportsToImport);
        this.dashboardImportService.validateAllDashboardsOrFail(dashboardsToImport);
        HashMap<String, EntityIdResponseDto> originalIdToNewIdMap = new HashMap<String, EntityIdResponseDto>();
        this.reportImportService.importReportsIntoCollection(collectionId, reportsToImport, originalIdToNewIdMap);
        this.dashboardImportService.importDashboardsIntoCollection(collectionId, dashboardsToImport, originalIdToNewIdMap);
        return new ArrayList<EntityIdResponseDto>(originalIdToNewIdMap.values());
    }

    public List<EntityIdResponseDto> importEntitiesAsUser(String userId, String collectionId, Set<OptimizeEntityExportDto> entitiesToImport) {
        CollectionDefinitionDto collection = this.getAndValidateCollectionExistsAndIsAccessibleOrFail(userId, collectionId);
        this.validateCompletenessOrFail(entitiesToImport);
        List<ReportDefinitionExportDto> reportsToImport = this.retrieveAllReportsToImport(entitiesToImport);
        List<DashboardDefinitionExportDto> dashboardsToImport = this.retrieveAllDashboardsToImport(entitiesToImport);
        this.reportImportService.validateAllReportsOrFail(userId, collection, reportsToImport);
        this.dashboardImportService.validateAllDashboardsOrFail(userId, dashboardsToImport);
        HashMap<String, EntityIdResponseDto> originalIdToNewIdMap = new HashMap<String, EntityIdResponseDto>();
        this.reportImportService.importReportsIntoCollection(userId, collectionId, reportsToImport, originalIdToNewIdMap);
        this.dashboardImportService.importDashboardsIntoCollection(userId, collectionId, dashboardsToImport, originalIdToNewIdMap);
        return new ArrayList<EntityIdResponseDto>(originalIdToNewIdMap.values());
    }

    public Set<OptimizeEntityExportDto> readExportDtoOrFailIfInvalid(String exportedDtoJson) {
        if (StringUtils.isEmpty((CharSequence)exportedDtoJson)) {
            throw new OptimizeImportFileInvalidException("Could not import entity because the provided file is null or empty.");
        }
        ObjectMapper objectMapper = new ObjectMapperFactory(new OptimizeDateTimeFormatterFactory().getObject(), this.configurationService).createOptimizeMapper();
        try {
            Set exportDtos = (Set)objectMapper.readValue(exportedDtoJson, (TypeReference)new TypeReference<Set<OptimizeEntityExportDto>>(this){});
            Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
            HashSet violations = new HashSet();
            exportDtos.forEach(exportDto -> violations.addAll(validator.validate(exportDto, new Class[0])));
            if (!violations.isEmpty()) {
                throw new OptimizeImportFileInvalidException(String.format("Could not import entities because the provided file contains invalid OptimizeExportDtos. Errors: %s", violations.stream().map(c -> String.valueOf(c.getPropertyPath()) + " " + c.getMessage()).collect(Collectors.joining(","))));
            }
            return exportDtos;
        }
        catch (JsonProcessingException e) {
            throw new OptimizeImportFileInvalidException("Could not import entities because the provided file is not a valid list of OptimizeEntityExportDtos. Error:" + e.getMessage());
        }
    }

    private List<ReportDefinitionExportDto> retrieveAllReportsToImport(Set<OptimizeEntityExportDto> entitiesToImport) {
        return entitiesToImport.stream().filter(entityToImport -> ExportEntityType.SINGLE_PROCESS_REPORT.equals((Object)entityToImport.getExportEntityType()) || ExportEntityType.SINGLE_DECISION_REPORT.equals((Object)entityToImport.getExportEntityType()) || ExportEntityType.COMBINED_REPORT.equals((Object)entityToImport.getExportEntityType())).map(reportToImport -> {
            if (reportToImport instanceof SingleProcessReportDefinitionExportDto && ((SingleProcessReportDefinitionExportDto)reportToImport).getData().isManagementReport()) {
                throw new OptimizeValidationException("Cannot import management reports");
            }
            return (ReportDefinitionExportDto)reportToImport;
        }).toList();
    }

    private List<DashboardDefinitionExportDto> retrieveAllDashboardsToImport(Set<OptimizeEntityExportDto> entitiesToImport) {
        return entitiesToImport.stream().filter(exportDto -> ExportEntityType.DASHBOARD.equals((Object)exportDto.getExportEntityType())).map(DashboardDefinitionExportDto.class::cast).toList();
    }

    private CollectionDefinitionDto getAndValidateCollectionExistsAndIsAccessibleOrFail(String userId, String collectionId) {
        return Optional.ofNullable(collectionId).map(collId -> Optional.ofNullable(userId).map(user -> this.authorizedCollectionService.getAuthorizedCollectionDefinitionOrFail((String)user, (String)collId).getDefinitionDto()).orElse(this.collectionService.getCollectionDefinition((String)collId))).orElse(null);
    }

    private void validateCompletenessOrFail(Set<OptimizeEntityExportDto> entitiesToImport) {
        Set importEntityIds = entitiesToImport.stream().map(OptimizeEntityExportDto::getId).collect(Collectors.toSet());
        HashSet requiredReportIds = new HashSet();
        entitiesToImport.forEach(entity -> {
            if (ExportEntityType.COMBINED_REPORT.equals((Object)entity.getExportEntityType())) {
                requiredReportIds.addAll(((CombinedProcessReportDefinitionExportDto)entity).getData().getReportIds());
            } else if (ExportEntityType.DASHBOARD.equals((Object)entity.getExportEntityType())) {
                requiredReportIds.addAll(((DashboardDefinitionExportDto)entity).getTileIds());
            }
        });
        if (!importEntityIds.containsAll(requiredReportIds)) {
            requiredReportIds.removeAll(importEntityIds);
            throw new OptimizeImportFileInvalidException("Could not import entities because the file is incomplete, some reports required by a combined report or dashboard are missing. The missing reports have IDs: " + String.valueOf(requiredReportIds));
        }
    }

    private void validateNoInstantPreviewEntities(Set<OptimizeEntityExportDto> entitiesToImport) {
        if (entitiesToImport.stream().anyMatch(exportDto -> ExportEntityType.DASHBOARD.equals((Object)exportDto.getExportEntityType()) && ((DashboardDefinitionExportDto)exportDto).isInstantPreviewDashboard() || ExportEntityType.SINGLE_PROCESS_REPORT.equals((Object)exportDto.getExportEntityType()) && ((SingleProcessReportDefinitionExportDto)exportDto).getData().isInstantPreviewReport())) {
            throw new OptimizeValidationException("Cannot import Instant preview dashboards and reports.");
        }
    }
}

