/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.email;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.EmailAuthenticationConfiguration;
import io.camunda.optimize.service.util.configuration.EmailSecurityProtocol;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Component
public class EmailService {
    private static final Logger LOG = LoggerFactory.getLogger(EmailService.class);
    private final ConfigurationService configurationService;
    @Autowired
    private final FreeMarkerConfigurer freemarkerConfigurer;

    public EmailService(ConfigurationService configurationService, FreeMarkerConfigurer freemarkerConfigurer) {
        this.configurationService = configurationService;
        this.freemarkerConfigurer = freemarkerConfigurer;
    }

    public void sendTemplatedEmailWithErrorHandling(String recipient, String subject, String templateName, Map<String, Object> templateInput) {
        this.sendEmailWithErrorHandling(recipient, this.composeEmailContentFromTemplate(templateName, templateInput), subject, true);
    }

    public void sendEmailWithErrorHandling(String recipient, String body, String subject) {
        this.sendEmailWithErrorHandling(recipient, body, subject, false);
    }

    private void sendEmailWithErrorHandling(String recipient, String body, String subject, boolean fromTemplate) {
        block8: {
            if (this.configurationService.getEmailEnabled()) {
                if (StringUtils.isNotEmpty((CharSequence)recipient)) {
                    try {
                        LOG.debug("Sending email [{}] to [{}]", (Object)subject, (Object)recipient);
                        if (fromTemplate) {
                            this.sendHtmlMessage(recipient, subject, body);
                            break block8;
                        }
                        this.sendEmail(recipient, subject, body);
                    }
                    catch (MessagingException e) {
                        LOG.error("Was not able to send email from [{}] to [{}]!", new Object[]{this.configurationService.getNotificationEmailAddress(), recipient, e});
                    }
                } else {
                    LOG.warn("There is no email destination specified, therefore not sending any email notifications.");
                }
            } else if (StringUtils.isNotEmpty((CharSequence)recipient)) {
                LOG.warn("The email service is not enabled, so no email will be sent. Please check the Optimize documentation on how to enable email notifications!");
            }
        }
    }

    private void sendEmail(String recipient, String subject, String body) throws MessagingException {
        MimeMessage message = this.createMimeMessage();
        message.setFrom((Address)new InternetAddress(this.configurationService.getNotificationEmailAddress()));
        EmailService.validateAddress(recipient);
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipient));
        message.setSubject(subject);
        message.setText(body, "utf-8");
        Transport.send((Message)message);
    }

    private static void validateAddress(String recipient) throws AddressException {
        InternetAddress.parse((String)recipient)[0].validate();
    }

    private void sendHtmlMessage(String recipient, String subject, String htmlBody) throws MessagingException {
        MimeMessage message = this.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
        helper.setTo(recipient);
        helper.setSubject(subject);
        helper.setText(htmlBody, true);
        helper.setFrom(this.configurationService.getNotificationEmailAddress());
        Transport.send((Message)message);
    }

    private MimeMessage createMimeMessage() {
        Session session;
        Properties properties = new Properties();
        properties.setProperty("mail.transport.protocol", "smtp");
        properties.put("mail.smtp.host", this.configurationService.getNotificationEmailHostname());
        properties.put("mail.smtp.port", this.configurationService.getNotificationEmailPort());
        final EmailAuthenticationConfiguration emailAuthenticationConfiguration = this.configurationService.getEmailAuthenticationConfiguration();
        if (Boolean.TRUE.equals(emailAuthenticationConfiguration.getEnabled())) {
            properties.put("mail.smtp.auth", "true");
            Authenticator auth = new Authenticator(this){

                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(emailAuthenticationConfiguration.getUsername(), emailAuthenticationConfiguration.getPassword());
                }
            };
            EmailSecurityProtocol securityProtocol = emailAuthenticationConfiguration.getSecurityProtocol();
            if (securityProtocol.equals((Object)EmailSecurityProtocol.STARTTLS)) {
                properties.put("mail.smtp.starttls.enable", "true");
                properties.setProperty("mail.smtp.ssl.checkserveridentity", this.configurationService.getNotificationEmailCheckServerIdentity().toString());
            } else if (securityProtocol.equals((Object)EmailSecurityProtocol.SSL_TLS)) {
                properties.setProperty("mail.smtp.port", this.configurationService.getNotificationEmailPort().toString());
                properties.setProperty("mail.smtp.socketFactory.port", this.configurationService.getNotificationEmailPort().toString());
                properties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                properties.setProperty("mail.smtp.socketFactory.fallback", "false");
                properties.setProperty("mail.smtp.ssl.checkserveridentity", this.configurationService.getNotificationEmailCheckServerIdentity().toString());
            }
            session = Session.getInstance((Properties)properties, (Authenticator)auth);
        } else {
            properties.put("mail.smtp.auth", "false");
            session = Session.getInstance((Properties)properties, null);
        }
        return new MimeMessage(session);
    }

    private String composeEmailContentFromTemplate(String templateName, Map<String, Object> templateInput) {
        try {
            Template freemarkerTemplate = this.freemarkerConfigurer.getConfiguration().getTemplate(templateName);
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)freemarkerTemplate, templateInput);
        }
        catch (IOException e) {
            String reason = String.format("Failed to read email template %s.", templateName);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
        catch (TemplateException e) {
            String reason = String.format("Failed to process email template  %s.", templateName);
            LOG.error(reason, (Throwable)e);
            throw new OptimizeRuntimeException(reason, (Throwable)e);
        }
    }
}

