/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.writer;

import io.camunda.optimize.dto.optimize.IdentityDto;
import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.RoleType;
import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDataDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionDefinitionUpdateDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionRoleRequestDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionRoleUpdateRequestDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionScopeEntryDto;
import io.camunda.optimize.dto.optimize.query.collection.CollectionScopeEntryUpdateDto;
import io.camunda.optimize.dto.optimize.query.collection.PartialCollectionDefinitionRequestDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.IdGenerator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CollectionWriter {
    public static final String DEFAULT_COLLECTION_NAME = "New Collection";
    public static final String UPDATE_ENTITY_SCRIPT_CODE = "Map newScopes = ctx._source.data.scope.stream()\n  .collect(Collectors.toMap(s -> s.id, Function.identity()));\nparams.scopeEntriesToUpdate\n  .forEach(newScope -> {\n     newScopes.computeIfPresent(newScope.id, (key, oldScope) -> {\n       newScope.tenants = Stream.concat(oldScope.tenants.stream(), newScope.tenants.stream())\n        .distinct()\n        .collect(Collectors.toList());\n       return newScope;\n     });\n     newScopes.putIfAbsent(newScope.id, newScope);\n  });\nctx._source.data.scope = newScopes.values();\nctx._source.lastModifier = params.lastModifier;\nctx._source.lastModified = params.lastModified;\n";
    public static final String REMOVE_SCOPE_ENTRY_FROM_COLLECTION_SCRIPT_CODE = "def scopes = ctx._source.data.scope;\nif(scopes != null) {\n   scopes.removeIf(scope -> scope.id.equals(params.scopeEntryIdToRemove));\n}\n";
    public static final String REMOVE_SCOPE_ENTRY_SCRIPT_CODE = "boolean removed = ctx._source.data.scope.removeIf(scope -> scope.id.equals(params.id));\nif (removed) {\n  ctx._source.lastModifier = params.lastModifier;\n  ctx._source.lastModified = params.lastModified;\n} else {\n  ctx.op = \"none\";\n}\n";
    public static final String REMOVE_SCOPE_ENTRIES_SCRIPT_CODE = "for (id in params.ids) {\n  ctx._source.data.scope.removeIf(scope -> scope.id.equals(id));\n}\nctx._source.lastModifier = params.lastModifier;\nctx._source.lastModified = params.lastModified;\n";
    public static final String UPDATE_SCOPE_ENTITY_SCRIPT_CODE = "def optionalEntry = ctx._source.data.scope.stream()\n  .filter(s -> s.id.equals(params.entryId))\n  .findFirst();\nif (optionalEntry.isPresent()) {\n  def entry = optionalEntry.get();\n  entry.tenants = params.entryDto.tenants;\n  ctx._source.lastModifier = params.lastModifier;\n  ctx._source.lastModified = params.lastModified;\n} else {\n  throw new Exception('Cannot find scope entry.');\n}\n";
    public static final String ADD_ROLE_TO_COLLECTION_SCRIPT_CODE = "def newRoles = new ArrayList();\nfor (roleToAdd in params.rolesToAdd) {\n    boolean exists = ctx._source.data.roles.stream()\n       .anyMatch(existingRole -> existingRole.id.equals(roleToAdd.id));\n    if (!exists){\n      newRoles.add(roleToAdd);\n    }\n}\nif (newRoles.size() == params.rolesToAdd.size()) {\n    ctx._source.data.roles.addAll(newRoles);\n    ctx._source.lastModifier = params.lastModifier;\n    ctx._source.lastModified = params.lastModified;\n} else {\n    ctx.op = \"none\";\n}\n";
    public static final String UPDATE_ROLE_IN_COLLECTION_SCRIPT_CODE = "def optionalExistingEntry = ctx._source.data.roles.stream()\n.filter(dto -> dto.id.equals(params.roleEntryId))\n.findFirst();\nif(optionalExistingEntry.isPresent()){\n   def existingEntry = optionalExistingEntry.get();\n   def moreThanOneManagerPresent = ctx._source.data.roles.stream()\n   .filter(dto -> params.managerRole.equals(dto.role))\n   .limit(2)\n   .count()\n    == 2;\nif (!moreThanOneManagerPresent && params.managerRole.equals(existingEntry.role)) {\n// updating of last manager is not allowed\n   ctx.op = \"none\";\n} else {\n   existingEntry.role = params.role;\n   ctx._source.lastModifier = params.lastModifier;\n   ctx._source.lastModified = params.lastModified;\n}\n} else {\nthrow new Exception('Cannot find role.');\n}\n";
    public static final String REMOVE_ROLE_FROM_COLLECTION_SCRIPT_CODE = "def optionalExistingEntry = ctx._source.data.roles.stream()\n.filter(dto -> dto.id.equals(params.roleEntryId))\n.findFirst();\nif(optionalExistingEntry.isPresent()){\n   def existingEntry = optionalExistingEntry.get();\n   ctx._source.data.roles.removeIf(entry -> entry.id.equals(params.roleEntryId));\n   if (params.containsKey(\"lastModifier\")) {\n      ctx._source.lastModifier = params.lastModifier;\n   }\n   if (params.containsKey(\"lastModified\")) {\n      ctx._source.lastModified = params.lastModified;\n   }\n} else {\n  throw new Exception('Cannot find role.');\n}\n";
    public static final String REMOVE_ROLE_FROM_COLLECTION_UNLESS_IS_LAST_MANAGER = "def optionalExistingEntry = ctx._source.data.roles.stream()\n.filter(dto -> dto.id.equals(params.roleEntryId))\n.findFirst();\nif(optionalExistingEntry.isPresent()){\n    def existingEntry = optionalExistingEntry.get();\n    def moreThanOneManagerPresent = ctx._source.data.roles.stream()\n    .filter(dto -> params.managerRole.equals(dto.role))\n    .limit(2)\n    .count()\n     == 2;\n    if (!moreThanOneManagerPresent && params.managerRole.equals(existingEntry.role)) {\n        // deletion of last manager is not allowed\n        ctx.op = \"none\";\n    } else {\n        ctx._source.data.roles.removeIf(entry -> entry.id.equals(params.roleEntryId));\n    if (params.containsKey(\"lastModifier\")) {\n        ctx._source.lastModifier = params.lastModifier;\n    }\n    if (params.containsKey(\"lastModified\")) {\n        ctx._source.lastModified = params.lastModified;\n    }\n}\n} else {\n   throw new Exception('Cannot find role.');\n}\n";
    public static final Logger LOG = LoggerFactory.getLogger(CollectionWriter.class);

    default public IdResponseDto createNewCollectionAndReturnId(String userId, PartialCollectionDefinitionRequestDto partialCollectionDefinitionDto) {
        if (userId == null) {
            throw new OptimizeRuntimeException("userId cannot be null");
        }
        if (partialCollectionDefinitionDto == null) {
            throw new OptimizeRuntimeException("partialCollectionDefinitionDto cannot be null");
        }
        return this.createNewCollectionAndReturnId(userId, partialCollectionDefinitionDto, IdGenerator.getNextId(), false);
    }

    default public IdResponseDto createNewCollectionAndReturnId(String userId, PartialCollectionDefinitionRequestDto partialCollectionDefinitionDto, String id, boolean automaticallyCreated) {
        if (userId == null) {
            throw new OptimizeRuntimeException("userId cannot be null");
        }
        if (partialCollectionDefinitionDto == null) {
            throw new OptimizeRuntimeException("partialCollectionDefinitionDto cannot be null");
        }
        if (id == null) {
            throw new OptimizeRuntimeException("id cannot be null");
        }
        LOG.debug("Writing new collection to Database");
        CollectionDefinitionDto collectionDefinitionDto = new CollectionDefinitionDto();
        collectionDefinitionDto.setId(id);
        collectionDefinitionDto.setCreated(LocalDateUtil.getCurrentDateTime());
        collectionDefinitionDto.setLastModified(LocalDateUtil.getCurrentDateTime());
        collectionDefinitionDto.setOwner(userId);
        collectionDefinitionDto.setLastModifier(userId);
        collectionDefinitionDto.setAutomaticallyCreated(automaticallyCreated);
        collectionDefinitionDto.setName(Optional.ofNullable(partialCollectionDefinitionDto.getName()).orElse(DEFAULT_COLLECTION_NAME));
        CollectionDataDto newCollectionDataDto = new CollectionDataDto();
        newCollectionDataDto.getRoles().add(new CollectionRoleRequestDto(new IdentityDto(userId, IdentityType.USER), RoleType.MANAGER));
        if (partialCollectionDefinitionDto.getData() != null) {
            newCollectionDataDto.setConfiguration(partialCollectionDefinitionDto.getData().getConfiguration());
        }
        collectionDefinitionDto.setData((Object)newCollectionDataDto);
        this.persistCollection(id, collectionDefinitionDto);
        return new IdResponseDto(id);
    }

    default public void createNewCollection(CollectionDefinitionDto collectionDefinitionDto) {
        if (collectionDefinitionDto == null) {
            throw new OptimizeRuntimeException("collectionDefinitionDto cannot be null");
        }
        this.persistCollection(collectionDefinitionDto.getId(), collectionDefinitionDto);
    }

    public void updateCollection(CollectionDefinitionUpdateDto var1, String var2);

    public void deleteCollection(String var1);

    public void addScopeEntriesToCollection(String var1, String var2, List<CollectionScopeEntryDto> var3);

    public void deleteScopeEntryFromAllCollections(String var1);

    public void updateScopeEntity(String var1, CollectionScopeEntryUpdateDto var2, String var3, String var4);

    public void removeScopeEntries(String var1, List<String> var2, String var3) throws NotFoundException;

    public void removeScopeEntry(String var1, String var2, String var3) throws NotFoundException;

    public void addRoleToCollection(String var1, List<CollectionRoleRequestDto> var2, String var3);

    public void updateRoleInCollection(String var1, String var2, CollectionRoleUpdateRequestDto var3, String var4);

    public void removeRoleFromCollectionUnlessIsLastManager(String var1, String var2, String var3);

    public void persistCollection(String var1, CollectionDefinitionDto var2);
}

