/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.util;

import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import java.util.Optional;

public final class ProcessVariableHelper {
    private ProcessVariableHelper() {
    }

    public static String getNestedVariableNameField() {
        return "variables.name";
    }

    public static String getNestedVariableIdField() {
        return "variables.id";
    }

    public static String getNestedVariableTypeField() {
        return "variables.type";
    }

    public static String getNestedVariableValueField() {
        return "variables.value";
    }

    public static String getValueSearchField(String searchFieldName) {
        return ProcessVariableHelper.getNestedVariableValueField() + "." + searchFieldName;
    }

    public static String buildWildcardQuery(String valueFilter) {
        return "*" + valueFilter + "*";
    }

    public static String getNestedVariableValueFieldForType(VariableType type) {
        return switch (Optional.ofNullable(type).orElseThrow(() -> new IllegalArgumentException("No Type provided"))) {
            case VariableType.BOOLEAN, VariableType.STRING, VariableType.OBJECT -> ProcessVariableHelper.getNestedVariableValueField();
            case VariableType.DOUBLE -> ProcessVariableHelper.getNestedVariableValueField() + ".double";
            case VariableType.SHORT, VariableType.INTEGER, VariableType.LONG -> ProcessVariableHelper.getNestedVariableValueField() + ".long";
            case VariableType.DATE -> ProcessVariableHelper.getNestedVariableValueField() + ".date";
            default -> throw new IllegalArgumentException("Unhandled type: " + String.valueOf(type));
        };
    }
}

