/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.script;

import io.camunda.optimize.service.db.es.writer.usertask.UserTaskDurationScriptUtil;
import java.util.Set;
import java.util.stream.Collectors;

public interface ZeebeProcessInstanceScriptFactory {
    public static String createProcessInstanceUpdateScript() {
        return ZeebeProcessInstanceScriptFactory.createUpdateProcessInstancePropertiesScript() + ZeebeProcessInstanceScriptFactory.createUpdateFlowNodeInstancesScript() + ZeebeProcessInstanceScriptFactory.createUpdateIncidentsScript();
    }

    private static String createUpdateProcessInstancePropertiesScript() {
        String simplePropertyUpdateScript = ZeebeProcessInstanceScriptFactory.createUpdatePropertyIfNotNullScript("newInstance", "existingInstance", Set.of("processInstanceId", "processDefinitionKey", "processDefinitionVersion", "processDefinitionId", "startDate", "endDate", "state", "dataSource"));
        return "def newInstance = params.instance;\ndef existingInstance = ctx._source;\n" + simplePropertyUpdateScript + "if (existingInstance.startDate != null && existingInstance.endDate != null) {\n  def dateFormatter = new SimpleDateFormat(params.dateFormatPattern);\n  existingInstance.duration = dateFormatter.parse(existingInstance.endDate).getTime() -\n    dateFormatter.parse(existingInstance.startDate).getTime();\n}\nif (existingInstance.variables == null) {\n  existingInstance.variables = new ArrayList();\n}\nif (newInstance.variables != null) {\n   existingInstance.variables = Stream.concat(existingInstance.variables.stream(), newInstance.variables.stream())\n   .collect(Collectors.toMap(variable -> variable.id, Function.identity(), (oldVar, newVar) ->\n      (newVar.version > oldVar.version) ? newVar : oldVar\n   )).values();\n}\n";
    }

    private static String createUpdateFlowNodeInstancesScript() {
        return "def flowNodesById = existingInstance.flowNodeInstances.stream()\n  .collect(Collectors.toMap(flowNode -> flowNode.flowNodeInstanceId, flowNode -> flowNode, (f1, f2) -> f1));\ndef newFlowNodes = params.instance.flowNodeInstances;\ndef isUserTaskImport = \"user-task\".equals(params.sourceExportIndex);\nfor (def newFlowNode : newFlowNodes) {\n  def existingFlowNode = flowNodesById.get(newFlowNode.flowNodeInstanceId);\n  if (existingFlowNode != null) {\n    if (newFlowNode.endDate != null && (existingFlowNode.endDate == null || isUserTaskImport)) {\n      existingFlowNode.endDate = newFlowNode.endDate;\n    }\n    if (newFlowNode.startDate != null && (existingFlowNode.startDate == null || isUserTaskImport)) {\n      existingFlowNode.startDate = newFlowNode.startDate;\n    }\n    if (existingFlowNode.startDate != null && existingFlowNode.endDate != null) {\n      def dateFormatter = new SimpleDateFormat(params.dateFormatPattern);\n      existingFlowNode.totalDurationInMs = dateFormatter.parse(existingFlowNode.endDate).getTime() -\n        dateFormatter.parse(existingFlowNode.startDate).getTime();\n    }\n    if (newFlowNode.canceled != null) {\n      existingFlowNode.canceled = newFlowNode.canceled;\n    }\n    if (existingFlowNode.assigneeOperations == null) {\n      existingFlowNode.assigneeOperations = new ArrayList();\n    }\n    if (newFlowNode.assigneeOperations != null && !newFlowNode.assigneeOperations.isEmpty()) {\n      existingFlowNode.assigneeOperations.addAll(newFlowNode.assigneeOperations);\n    }\n    if (isUserTaskImport) {\n      existingFlowNode.assignee = newFlowNode.assignee;\n      existingFlowNode.candidateGroups = newFlowNode.candidateGroups;\n    }\n  } else {\n    flowNodesById.put(newFlowNode.flowNodeInstanceId, newFlowNode);\n  }\n}\nexistingInstance.flowNodeInstances = flowNodesById.values();\n" + UserTaskDurationScriptUtil.createUpdateUserTaskMetricsScript();
    }

    private static String createUpdateIncidentsScript() {
        String simplePropertyUpdateScript = ZeebeProcessInstanceScriptFactory.createUpdatePropertyIfNotNullScript("newIncident", "existingIncident", Set.of("createTime", "endTime"));
        return "def incidentsById = existingInstance.incidents.stream()\n  .collect(Collectors.toMap(incident -> incident.id, incident -> incident, (f1, f2) -> f1));\ndef newIncidents = params.instance.incidents;\nfor (def newIncident : newIncidents) {\n  def existingIncident = incidentsById.get(newIncident.id);\n  if (existingIncident != null) {\n" + simplePropertyUpdateScript + "    if (existingIncident.createTime != null && existingIncident.endTime != null) {\n      def dateFormatter = new SimpleDateFormat(params.dateFormatPattern);\n      existingIncident.durationInMs = dateFormatter.parse(existingIncident.endTime).getTime() -\n        dateFormatter.parse(existingIncident.createTime).getTime();\n    }\n    if (existingIncident.incidentStatus.equals(\"open\")) {\n      existingIncident.incidentStatus = newIncident.incidentStatus;\n    }\n  } else {\n    incidentsById.put(newIncident.id, newIncident);\n  }\n}\n    def flowNodeIdsByFlowNodeInstanceIds = flowNodesById.values()\n      .stream()\n      .collect(Collectors.toMap(flowNode -> flowNode.flowNodeInstanceId, flowNode -> flowNode.flowNodeId));\n    existingInstance.incidents = incidentsById.values()\n      .stream()\n      .peek(incident -> {\n         def flowNodeId = flowNodeIdsByFlowNodeInstanceIds.get(incident.activityId);\n         if (flowNodeId != null) {\n           incident.activityId = flowNodeId;\n         }\n         incident.definitionVersion = existingInstance.processDefinitionVersion;\n         return incident;\n      })\n      .collect(Collectors.toList());\n";
    }

    private static String createUpdatePropertyIfNotNullScript(String newEntityName, String existingEntityName, Set<String> propertiesToUpdate) {
        String simplePropertyUpdateScript = "if (%s.%s != null) {\n  %s.%s = %s.%s;\n}\n";
        return propertiesToUpdate.stream().map(propertyName -> "if (%s.%s != null) {\n  %s.%s = %s.%s;\n}\n".formatted(newEntityName, propertyName, existingEntityName, propertyName, newEntityName, propertyName)).collect(Collectors.joining("\n"));
    }
}

