/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.es;

import io.camunda.optimize.service.db.es.MappingMetadataUtilES;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.repository.MappingMetadataRepository;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class MappingMetadataRepositoryES
implements MappingMetadataRepository {
    private static final Logger LOG = LoggerFactory.getLogger(MappingMetadataRepositoryES.class);
    private final OptimizeElasticsearchClient esClient;

    public MappingMetadataRepositoryES(OptimizeElasticsearchClient esClient) {
        this.esClient = esClient;
    }

    @Override
    public String[] getIndexAliasesWithImportIndexFlag(boolean isImportIndex) {
        MappingMetadataUtilES mappingUtil = new MappingMetadataUtilES(this.esClient);
        return (String[])mappingUtil.getAllMappings(this.esClient.getIndexNameService().getIndexPrefix()).stream().filter(mapping -> isImportIndex == mapping.isImportIndex()).map(arg_0 -> ((OptimizeIndexNameService)this.esClient.getIndexNameService()).getOptimizeIndexAliasForIndex(arg_0)).toArray(String[]::new);
    }
}

