/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.es;

import co.elastic.clients.elasticsearch.indices.IndexSettings;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.schema.ElasticSearchSchemaManager;
import io.camunda.optimize.service.db.repository.IndexRepository;
import io.camunda.optimize.service.db.schema.IndexMappingCreator;
import io.camunda.optimize.service.db.schema.OptimizeIndexNameService;
import io.camunda.optimize.service.db.schema.index.IndexMappingCreatorBuilder;
import io.camunda.optimize.service.util.configuration.ConfigurationReloadable;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class IndexRepositoryES
implements IndexRepository,
ConfigurationReloadable {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRepositoryES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ElasticSearchSchemaManager elasticSearchSchemaManager;
    private final OptimizeIndexNameService indexNameService;
    private final Set<String> indices = ConcurrentHashMap.newKeySet();

    public IndexRepositoryES(OptimizeElasticsearchClient esClient, ElasticSearchSchemaManager elasticSearchSchemaManager, OptimizeIndexNameService indexNameService) {
        this.esClient = esClient;
        this.elasticSearchSchemaManager = elasticSearchSchemaManager;
        this.indexNameService = indexNameService;
    }

    @Override
    public void createMissingIndices(IndexMappingCreatorBuilder indexMappingCreatorBuilder, Set<String> readOnlyAliases, Set<String> keys) {
        keys.stream().map(indexMappingCreatorBuilder.getElasticsearch()).filter(indexMappingCreator -> !this.indexExists(this.getIndexName((IndexMappingCreator<IndexSettings.Builder>)indexMappingCreator))).forEach(indexMappingCreator -> this.createMissingIndex((IndexMappingCreator<IndexSettings.Builder>)indexMappingCreator, readOnlyAliases));
    }

    public void reloadConfiguration(ApplicationContext context) {
        this.indices.clear();
    }

    @Override
    public boolean indexExists(IndexMappingCreatorBuilder indexMappingCreatorBuilder, String key) {
        return this.indexExists(((IndexMappingCreator)indexMappingCreatorBuilder.getElasticsearch().apply(key)).getIndexName());
    }

    private String getIndexName(IndexMappingCreator<IndexSettings.Builder> indexMappingCreator) {
        return this.indexNameService.getOptimizeIndexNameWithVersion(indexMappingCreator);
    }

    private void createMissingIndex(IndexMappingCreator<IndexSettings.Builder> indexMappingCreator, Set<String> readOnlyAliases) {
        LOG.debug("Creating index {}.", (Object)this.getIndexName(indexMappingCreator));
        this.elasticSearchSchemaManager.createOrUpdateOptimizeIndex(this.esClient, indexMappingCreator, readOnlyAliases);
        String index = this.getIndexName(indexMappingCreator);
        this.indices.add(index);
    }

    private boolean indexExists(String index) {
        return this.indices.contains(index) || this.elasticSearchSchemaManager.indexExists(this.esClient, index);
    }
}

