/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository.es;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.GetResponse;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.OptimizeDto;
import io.camunda.optimize.dto.optimize.datasource.DataSourceDto;
import io.camunda.optimize.dto.optimize.index.ImportIndexDto;
import io.camunda.optimize.dto.optimize.index.PositionBasedImportIndexDto;
import io.camunda.optimize.dto.optimize.index.TimestampBasedImportIndexDto;
import io.camunda.optimize.service.db.es.OptimizeElasticsearchClient;
import io.camunda.optimize.service.db.es.builders.OptimizeGetRequestBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeIndexOperationBuilderES;
import io.camunda.optimize.service.db.es.builders.OptimizeSearchRequestBuilderES;
import io.camunda.optimize.service.db.es.reader.ElasticsearchReaderUtil;
import io.camunda.optimize.service.db.repository.ImportRepository;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.DatabaseHelper;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.ElasticSearchCondition;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ImportRepositoryES
implements ImportRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ImportRepositoryES.class);
    private final OptimizeElasticsearchClient esClient;
    private final ObjectMapper objectMapper;
    private final ConfigurationService configurationService;
    private final DateTimeFormatter dateTimeFormatter;

    public ImportRepositoryES(OptimizeElasticsearchClient esClient, ObjectMapper objectMapper, ConfigurationService configurationService, DateTimeFormatter dateTimeFormatter) {
        this.esClient = esClient;
        this.objectMapper = objectMapper;
        this.configurationService = configurationService;
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public List<TimestampBasedImportIndexDto> getAllTimestampBasedImportIndicesForTypes(List<String> indexTypes) {
        SearchResponse searchResponse;
        LOG.debug("Fetching timestamp based import indices of types '{}'", indexTypes);
        SearchRequest searchRequest = OptimizeSearchRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, new String[]{"timestamp-based-import-index"}).query(q -> q.terms(t -> t.field("esTypeIndexRefersTo").terms(ft -> ft.value(indexTypes.stream().map(FieldValue::of).toList())))).size(Integer.valueOf(1000)));
        try {
            searchResponse = this.esClient.search(searchRequest, TimestampBasedImportIndexDto.class);
        }
        catch (IOException e) {
            LOG.error("Was not able to get timestamp based import indices!", (Throwable)e);
            throw new OptimizeRuntimeException("Was not able to get timestamp based import indices!", (Throwable)e);
        }
        return ElasticsearchReaderUtil.mapHits(searchResponse.hits(), TimestampBasedImportIndexDto.class, this.objectMapper);
    }

    @Override
    public <T extends ImportIndexDto<D>, D extends DataSourceDto> Optional<T> getImportIndex(String indexName, String indexType, Class<T> importDTOClass, String typeIndexComesFrom, D dataSourceDto) {
        LOG.debug("Fetching {} import index of type '{}'", (Object)indexType, (Object)typeIndexComesFrom);
        GetResponse getResponse = null;
        GetRequest getRequest = OptimizeGetRequestBuilderES.of(b -> b.optimizeIndex(this.esClient, indexName).id(DatabaseHelper.constructKey(typeIndexComesFrom, dataSourceDto)));
        try {
            getResponse = this.esClient.get(getRequest, importDTOClass);
        }
        catch (IOException e) {
            LOG.error("Could not fetch {} import index", (Object)indexType, (Object)e);
        }
        if (getResponse != null && getResponse.source() != null) {
            return Optional.of((ImportIndexDto)getResponse.source());
        }
        LOG.debug("Was not able to retrieve {} import index for type [{}] and engine [{}] from elasticsearch.", new Object[]{indexType, typeIndexComesFrom, dataSourceDto});
        return Optional.empty();
    }

    @Override
    public void importPositionBasedIndices(String importItemName, List<PositionBasedImportIndexDto> importIndexDtos) {
        this.esClient.doImportBulkRequestWithList(importItemName, importIndexDtos, this::addPositionBasedImportIndexRequest, this.configurationService.getSkipDataAfterNestedDocLimitReached().booleanValue());
    }

    @Override
    public void importIndices(String importItemName, List<TimestampBasedImportIndexDto> timestampBasedImportIndexDtos) {
        this.esClient.doImportBulkRequestWithList(importItemName, timestampBasedImportIndexDtos, this::addImportIndexRequest, this.configurationService.getSkipDataAfterNestedDocLimitReached().booleanValue());
    }

    private void addPositionBasedImportIndexRequest(BulkRequest.Builder bulkRequestBuilder, PositionBasedImportIndexDto optimizeDto) {
        LOG.debug("Writing position based import index of type [{}] with position [{}] to elasticsearch", (Object)optimizeDto.getDbTypeIndexRefersTo(), (Object)optimizeDto.getPositionOfLastEntity());
        bulkRequestBuilder.operations(b -> b.index(OptimizeIndexOperationBuilderES.of(ib -> ((IndexOperation.Builder)ib.optimizeIndex(this.esClient, "position-based-import-index").id(DatabaseHelper.constructKey(optimizeDto.getDbTypeIndexRefersTo(), optimizeDto.getDataSource()))).document((Object)optimizeDto))));
    }

    private void addImportIndexRequest(BulkRequest.Builder bulkRequestBuilder, OptimizeDto optimizeDto) {
        bulkRequestBuilder.operations(b -> {
            if (optimizeDto instanceof TimestampBasedImportIndexDto) {
                TimestampBasedImportIndexDto timestampBasedIndexDto = (TimestampBasedImportIndexDto)optimizeDto;
                return b.index(OptimizeIndexOperationBuilderES.of(ib -> this.createTimestampBasedRequest((OptimizeIndexOperationBuilderES<TimestampBasedImportIndexDto>)ib, timestampBasedIndexDto)));
            }
            return b;
        });
    }

    private IndexOperation.Builder<TimestampBasedImportIndexDto> createTimestampBasedRequest(OptimizeIndexOperationBuilderES<TimestampBasedImportIndexDto> builder, TimestampBasedImportIndexDto importIndex) {
        String currentTimeStamp = this.dateTimeFormatter.format(importIndex.getTimestampOfLastEntity());
        LOG.debug("Writing timestamp based import index [{}] of type [{}] with execution timestamp [{}] to elasticsearch", new Object[]{currentTimeStamp, importIndex.getDbTypeIndexRefersTo(), importIndex.getLastImportExecutionTimestamp()});
        return ((IndexOperation.Builder)builder.optimizeIndex(this.esClient, "timestamp-based-import-index").id(this.getId(importIndex))).document((Object)importIndex);
    }

    private String getId(TimestampBasedImportIndexDto importIndex) {
        return DatabaseHelper.constructKey(importIndex.getDbTypeIndexRefersTo(), importIndex.getDataSourceName());
    }
}

