/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.repository;

import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.BackoffCalculator;
import io.camunda.optimize.service.util.PeriodicAction;
import io.camunda.optimize.upgrade.es.TaskResponse;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskRepository {
    protected static final String TASKS_ENDPOINT = "_tasks";
    private static final Logger LOG = LoggerFactory.getLogger(TaskRepository.class);

    public abstract List<TaskProgressInfo> tasksProgress(String var1);

    public abstract TaskResponse getTaskResponse(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithTaskMonitoring(String action, Runnable runnable, Logger log) {
        PeriodicAction progressReporter = new PeriodicAction(this.getClass().getName(), () -> this.tasksProgress(action).forEach(tasksProgressInfo -> LOG.info("Current {} BulkByScrollTaskTask progress: {}%, total: {}, done: {}", new Object[]{action, tasksProgressInfo.progress(), tasksProgressInfo.totalCount(), tasksProgressInfo.processedCount()})));
        try {
            progressReporter.start();
            runnable.run();
        }
        finally {
            progressReporter.stop();
        }
    }

    public void waitUntilTaskIsFinished(String taskId, String taskItemIdentifier) {
        BackoffCalculator backoffCalculator = new BackoffCalculator(1000L, 10L);
        boolean finished = false;
        int progress = -1;
        while (!finished) {
            try {
                TaskResponse taskResponse = this.getTaskResponse(taskId);
                TaskRepository.validateTaskResponse(taskResponse);
                int currentProgress = (int)(taskResponse.getProgress() * 100.0);
                if (currentProgress != progress) {
                    TaskResponse.Status taskStatus = taskResponse.getTaskStatus();
                    progress = currentProgress;
                    LOG.info("Progress of task (ID:{}) on {}: {}% (total: {}, updated: {}, created: {}, deleted: {}). Completed: {}", new Object[]{taskId, taskItemIdentifier, progress, taskStatus.getTotal(), taskStatus.getUpdated(), taskStatus.getCreated(), taskStatus.getDeleted(), taskResponse.isCompleted()});
                }
                if (finished = taskResponse.isCompleted()) continue;
                Thread.sleep(backoffCalculator.calculateSleepTime());
            }
            catch (InterruptedException e) {
                LOG.error("Waiting for database task (ID: {}) completion was interrupted!", (Object)taskId, (Object)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                throw new OptimizeRuntimeException(String.format("Error while trying to read database task (ID: %s) progress!", taskId), (Throwable)e);
            }
        }
    }

    public static void validateTaskResponse(TaskResponse taskResponse) {
        List failures;
        if (taskResponse == null) {
            String errorMsg = "Not able to retrieve task status";
            LOG.error("Not able to retrieve task status");
            throw new OptimizeRuntimeException("Not able to retrieve task status");
        }
        if (taskResponse.getError() != null) {
            LOG.error("A database task failed with error: {}", (Object)taskResponse.getError());
            throw new OptimizeRuntimeException(taskResponse.getError().toString());
        }
        if (taskResponse.getResponseDetails() != null && (failures = taskResponse.getResponseDetails().getFailures()) != null && !failures.isEmpty()) {
            LOG.error("A database task contained failures: {}", (Object)failures);
            throw new OptimizeRuntimeException(failures.toString());
        }
    }

    protected static long getProcessedTasksCount(JsonObject status) {
        return status.getInt("deleted") + status.getInt("created") + status.getInt("updated");
    }

    protected static int getProgress(JsonObject status) {
        return status.getInt("total") > 0 ? Double.valueOf((double)TaskRepository.getProcessedTasksCount(status) / (double)status.getInt("total") * 100.0).intValue() : 0;
    }

    public record TaskProgressInfo(int progress, long totalCount, long processedCount) {
    }
}

