/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.result;

import io.camunda.optimize.dto.optimize.query.report.CommandEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.ViewProperty;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.MeasureDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.ResultType;
import io.camunda.optimize.dto.optimize.query.report.single.result.hyper.MapResultEntryDto;
import io.camunda.optimize.service.export.CSVUtils;
import java.time.ZoneId;
import java.util.List;

public class MapCommandResult
extends CommandEvaluationResult<List<MapResultEntryDto>> {
    public MapCommandResult(List<MeasureDto<List<MapResultEntryDto>>> measures, SingleReportDataDto reportDataDto) {
        super(measures, (ReportDataDto)reportDataDto);
        if (measures == null) {
            throw new IllegalArgumentException("measures cannot be null");
        }
        if (reportDataDto == null) {
            throw new IllegalArgumentException("reportDataDto cannot be null");
        }
    }

    @Override
    public List<String[]> getResultAsCsv(Integer limit, Integer offset, ZoneId timezone) {
        List<String[]> csvStrings = CSVUtils.map((List)this.getFirstMeasureData(), limit, offset);
        this.addCsvHeader(csvStrings);
        return csvStrings;
    }

    @Override
    public ResultType getType() {
        return ResultType.MAP;
    }

    public void addCsvHeader(List<String[]> csvStrings) {
        if (this.getReportDataAs(SingleReportDataDto.class).getViewProperties().contains(ViewProperty.FREQUENCY)) {
            this.addFrequencyHeader(csvStrings);
        } else {
            this.addDurationHeader(csvStrings);
        }
    }

    private void addDurationHeader(List<String[]> csvStrings) {
        SingleReportDataDto singleReportData = this.getReportDataAs(SingleReportDataDto.class);
        String normalizedCommandKey = this.getViewIdentifier(singleReportData);
        String[] operations = new String[]{"", CSVUtils.mapAggregationType((AggregationDto)singleReportData.getConfiguration().getAggregationTypes().iterator().next())};
        csvStrings.add(0, operations);
        String[] header = new String[]{this.getGroupByIdentifier(singleReportData), normalizedCommandKey};
        csvStrings.add(0, header);
    }

    private void addFrequencyHeader(List<String[]> csvStrings) {
        SingleReportDataDto singleReportDataDto = this.getReportDataAs(SingleReportDataDto.class);
        String normalizedCommandKey = this.getViewIdentifier(singleReportDataDto);
        csvStrings.add(0, new String[]{this.getGroupByIdentifier(singleReportDataDto), normalizedCommandKey});
    }
}

