/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.result;

import com.google.common.collect.Streams;
import io.camunda.optimize.dto.optimize.query.report.CommandEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.MeasureDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.ResultType;
import io.camunda.optimize.dto.optimize.query.report.single.result.hyper.HyperMapResultEntryDto;
import io.camunda.optimize.service.export.CSVUtils;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HyperMapCommandResult
extends CommandEvaluationResult<List<HyperMapResultEntryDto>> {
    private static final Logger LOG = LoggerFactory.getLogger(HyperMapCommandResult.class);

    public HyperMapCommandResult(List<MeasureDto<List<HyperMapResultEntryDto>>> measures, ProcessReportDataDto reportDataDto) {
        super(measures, (ReportDataDto)reportDataDto);
        if (measures == null) {
            throw new IllegalArgumentException("measures cannot be null");
        }
        if (reportDataDto == null) {
            throw new IllegalArgumentException("reportDataDto cannot be null");
        }
    }

    @Override
    public List<String[]> getResultAsCsv(Integer limit, Integer offset, ZoneId timezone) {
        return this.mapHyperMapReportResultsToCsvList(limit, (List)this.getFirstMeasureData());
    }

    @Override
    public ResultType getType() {
        return ResultType.HYPER_MAP;
    }

    private List<String[]> mapHyperMapReportResultsToCsvList(Integer limit, List<HyperMapResultEntryDto> hyperMapResult) {
        List<List<String[]>> allSingleReportsAsCsvList = this.mapHyperMapReportResultsToCsvLists(limit, hyperMapResult);
        List<String[]> mergedCsvReports = this.mergeSingleReportsToOneCsv(allSingleReportsAsCsvList);
        this.addHeaderLine(mergedCsvReports);
        return mergedCsvReports;
    }

    private void addHeaderLine(List<String[]> mergedCsvReports) {
        ProcessReportDataDto data = (ProcessReportDataDto)this.reportData;
        String[] reportNameHeader = new String[]{data.getDistributedBy().createCommandKey(), data.getGroupBy().createCommandKey()};
        mergedCsvReports.add(0, reportNameHeader);
    }

    private List<List<String[]>> mapHyperMapReportResultsToCsvLists(Integer limit, List<HyperMapResultEntryDto> hyperMapResult) {
        return Streams.mapWithIndex(hyperMapResult.stream(), (hyperMapResultEntry, index) -> this.mapSingleHyperMapResultEntry(limit, (HyperMapResultEntryDto)hyperMapResultEntry, index > 0L)).collect(Collectors.toList());
    }

    private List<String[]> removeLabelColumn(List<String[]> column) {
        return column.stream().map(row -> ((String[])row).length > 1 ? (String[])ArrayUtils.remove((Object[])row, (int)0) : row).collect(Collectors.toList());
    }

    private List<String[]> mapSingleHyperMapResultEntry(Integer limit, HyperMapResultEntryDto resultEntryDto, boolean removeLabelColumn) {
        List<String[]> csvStrings = CSVUtils.map(resultEntryDto.getValue(), limit, 0);
        String label = resultEntryDto.getLabel();
        String[] header = new String[]{"", label};
        csvStrings.add(0, header);
        if (removeLabelColumn) {
            csvStrings = this.removeLabelColumn(csvStrings);
        }
        return csvStrings;
    }

    private List<String[]> mergeSingleReportsToOneCsv(List<List<String[]>> allSingleReportsAsCsvList) {
        int numberOfRows = allSingleReportsAsCsvList.stream().mapToInt(List::size).max().orElse(0);
        return allSingleReportsAsCsvList.stream().reduce((l1, l2) -> {
            this.fillMissingRowsWithEmptyEntries(numberOfRows, (List<String[]>)l1);
            this.fillMissingRowsWithEmptyEntries(numberOfRows, (List<String[]>)l2);
            for (int i = 0; i < l1.size(); ++i) {
                l1.set(i, (String[])ArrayUtils.addAll((Object[])((String[])l1.get(i)), (Object[])((String[])l2.get(i))));
            }
            return l1;
        }).orElseGet(() -> {
            String message = "Was not able to merge single map entry to hyper map report csv";
            LOG.warn("Was not able to merge single map entry to hyper map report csv");
            return new ArrayList();
        });
    }

    private void fillMissingRowsWithEmptyEntries(int numberOfRows, List<String[]> l1) {
        Object[] l1Fill = new String[l1.get(0).length];
        Arrays.fill(l1Fill, "");
        IntStream.range(l1.size(), numberOfRows).forEach(arg_0 -> HyperMapCommandResult.lambda$fillMissingRowsWithEmptyEntries$4(l1, (String[])l1Fill, arg_0));
    }

    private static /* synthetic */ void lambda$fillMissingRowsWithEmptyEntries$4(List l1, String[] l1Fill, int i) {
        l1.add(l1Fill);
    }
}

