/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.result;

import io.camunda.optimize.dto.optimize.query.report.CommandEvaluationResult;
import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.RawDataInstanceDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.ViewProperty;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.AggregationDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.DistributedByType;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.UserTaskDurationTime;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.view.ProcessViewEntity;
import io.camunda.optimize.dto.optimize.query.report.single.process.view.VariableViewPropertyDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.MeasureDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.hyper.HyperMapResultEntryDto;
import io.camunda.optimize.dto.optimize.query.report.single.result.hyper.MapResultEntryDto;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.service.db.report.result.HyperMapCommandResult;
import io.camunda.optimize.service.db.report.result.MapCommandResult;
import io.camunda.optimize.service.db.report.result.NumberCommandResult;
import io.camunda.optimize.service.db.report.result.RawDataCommandResult;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class CompositeCommandResult {
    private final SingleReportDataDto reportDataDto;
    private final ViewProperty viewProperty;
    private ReportSortingDto groupBySorting = new ReportSortingDto();
    private ReportSortingDto distributedBySorting = new ReportSortingDto();
    private boolean isGroupByKeyOfNumericType = false;
    private boolean isDistributedByKeyOfNumericType = false;
    private Supplier<Double> defaultNumberValueSupplier = () -> 0.0;
    private List<GroupByResult> groups = new ArrayList<GroupByResult>();

    public CompositeCommandResult(SingleReportDataDto reportDataDto, ViewProperty viewProperty, Double defaultNumberValue) {
        this.reportDataDto = reportDataDto;
        this.viewProperty = viewProperty;
        this.defaultNumberValueSupplier = () -> defaultNumberValue;
    }

    public CompositeCommandResult(SingleReportDataDto reportDataDto, ViewProperty viewProperty) {
        this.reportDataDto = reportDataDto;
        this.viewProperty = viewProperty;
    }

    public void setGroup(GroupByResult groupByResult) {
        this.groups = Collections.singletonList(groupByResult);
    }

    public CommandEvaluationResult<List<HyperMapResultEntryDto>> transformToHyperMap() {
        Map<ViewMeasureIdentifier, List> measureDataSets = this.createMeasureMap(ArrayList::new);
        for (GroupByResult group : this.groups) {
            Map<ViewMeasureIdentifier, List> distributionsByAggregationType = this.createMeasureMap(ArrayList::new);
            group.distributions.forEach(distributedByResult -> distributedByResult.getViewResult().getViewMeasures().forEach(viewMeasure -> ((List)distributionsByAggregationType.get(viewMeasure.getViewMeasureIdentifier())).add(new MapResultEntryDto(distributedByResult.getKey(), viewMeasure.getValue(), distributedByResult.getLabel()))));
            distributionsByAggregationType.forEach((type, mapResultEntryDtos) -> {
                mapResultEntryDtos.sort(this.getSortingComparator(this.distributedBySorting, this.isDistributedByKeyOfNumericType));
                ((List)measureDataSets.get(type)).add(new HyperMapResultEntryDto(group.getKey(), mapResultEntryDtos, group.getLabel()));
            });
        }
        measureDataSets.values().forEach(hyperMapData -> this.sortHypermapResultData(this.groupBySorting, this.isGroupByKeyOfNumericType, (List<HyperMapResultEntryDto>)hyperMapData));
        return new HyperMapCommandResult(measureDataSets.entrySet().stream().map(measureDataEntry -> this.createMeasureDto((ViewMeasureIdentifier)measureDataEntry.getKey(), (List)measureDataEntry.getValue())).collect(Collectors.toList()), (ProcessReportDataDto)this.reportDataDto);
    }

    public CommandEvaluationResult<List<MapResultEntryDto>> transformToMap() {
        Map<ViewMeasureIdentifier, List> measureDataSets = this.createMeasureMap(ArrayList::new);
        for (GroupByResult group : this.groups) {
            group.getDistributions().forEach(distributedByResult -> distributedByResult.getViewResult().getViewMeasures().forEach(viewMeasure -> ((List)measureDataSets.get(viewMeasure.getViewMeasureIdentifier())).add(new MapResultEntryDto(group.getKey(), viewMeasure.getValue(), group.getLabel()))));
        }
        measureDataSets.values().forEach(mapData -> mapData.sort(this.getSortingComparator(this.groupBySorting, this.isGroupByKeyOfNumericType)));
        return new MapCommandResult(measureDataSets.entrySet().stream().map(measureEntry -> this.createMeasureDto((ViewMeasureIdentifier)measureEntry.getKey(), (List)measureEntry.getValue())).collect(Collectors.toList()), this.reportDataDto);
    }

    public CommandEvaluationResult<Double> transformToNumber() {
        Map<ViewMeasureIdentifier, Double> measureDataSets = this.createMeasureMap(this.defaultNumberValueSupplier);
        if (this.groups.size() == 1) {
            List<DistributedByResult> distributions = this.groups.get((int)0).distributions;
            if (distributions.size() == 1) {
                List<ViewMeasure> measures = distributions.get(0).getViewResult().getViewMeasures();
                for (ViewMeasure viewMeasure : measures) {
                    measureDataSets.put(viewMeasure.getViewMeasureIdentifier(), viewMeasure.getValue());
                }
            } else {
                throw new OptimizeRuntimeException(this.createErrorMessage(NumberCommandResult.class, DistributedByType.class));
            }
        }
        return new NumberCommandResult(measureDataSets.entrySet().stream().map(measureEntry -> this.createMeasureDto((ViewMeasureIdentifier)measureEntry.getKey(), (Double)measureEntry.getValue())).collect(Collectors.toList()), this.reportDataDto);
    }

    private <T> Map<ViewMeasureIdentifier, T> createMeasureMap(Supplier<T> defaultValueSupplier) {
        LinkedHashMap measureMap = new LinkedHashMap();
        if (ViewProperty.FREQUENCY.equals((Object)this.viewProperty) || ViewProperty.PERCENTAGE.equals((Object)this.viewProperty)) {
            measureMap.put(new ViewMeasureIdentifier(), defaultValueSupplier.get());
        }
        if (this.isUserTaskDurationResult()) {
            this.reportDataDto.getConfiguration().getUserTaskDurationTimes().forEach(userTaskDurationTime -> this.reportDataDto.getConfiguration().getAggregationTypes().forEach(arg_0 -> CompositeCommandResult.lambda$createMeasureMap$12(measureMap, userTaskDurationTime, (Supplier)defaultValueSupplier, arg_0)));
        } else if (ViewProperty.DURATION.equals((Object)this.viewProperty) || this.isNumberVariableView()) {
            this.reportDataDto.getConfiguration().getAggregationTypes().forEach(aggregationType -> measureMap.put(new ViewMeasureIdentifier((AggregationDto)aggregationType, null), defaultValueSupplier.get()));
        }
        return measureMap;
    }

    public <T extends RawDataInstanceDto> CommandEvaluationResult<List<T>> transformToRawData() {
        RawDataCommandResult<List<Object>> rawDataCommandResult = new RawDataCommandResult<List<Object>>((ReportDataDto)this.reportDataDto);
        if (this.groups.isEmpty()) {
            rawDataCommandResult.addMeasure(this.createMeasureDto(Collections.emptyList()));
            rawDataCommandResult.setPagination(new PaginationDto(Integer.valueOf(20), Integer.valueOf(0)));
            return rawDataCommandResult;
        }
        if (this.groups.size() == 1) {
            List<DistributedByResult> distributions = this.groups.get((int)0).distributions;
            if (distributions.size() == 1) {
                rawDataCommandResult.addMeasure(this.createMeasureDto(distributions.get(0).getViewResult().getRawData()));
                return rawDataCommandResult;
            }
            throw new OptimizeRuntimeException(this.createErrorMessage(RawDataCommandResult.class, DistributedByType.class));
        }
        throw new OptimizeRuntimeException(this.createErrorMessage(RawDataCommandResult.class, GroupByResult.class));
    }

    private <T> MeasureDto<T> createMeasureDto(T value) {
        return this.createMeasureDto(new ViewMeasureIdentifier(), value);
    }

    private <T> MeasureDto<T> createMeasureDto(ViewMeasureIdentifier viewMeasureIdentifier, T value) {
        return new MeasureDto(this.viewProperty, viewMeasureIdentifier.getAggregationType(), viewMeasureIdentifier.getUserTaskDurationTime(), value);
    }

    private boolean isUserTaskDurationResult() {
        return this.reportDataDto instanceof ProcessReportDataDto && ProcessViewEntity.USER_TASK.equals((Object)((ProcessReportDataDto)this.reportDataDto).getView().getEntity()) && ViewProperty.DURATION.equals((Object)this.viewProperty);
    }

    private boolean isNumberVariableView() {
        return Optional.ofNullable(this.viewProperty).flatMap(value -> value.getViewPropertyDtoIfOfType(VariableViewPropertyDto.class)).map(VariableViewPropertyDto::getType).filter(propertyType -> VariableType.getNumericTypes().contains(propertyType)).isPresent();
    }

    private Comparator<MapResultEntryDto> getSortingComparator(ReportSortingDto sorting, boolean keyIsOfNumericType) {
        String sortBy = sorting.getBy().orElse("key");
        SortOrder sortOrder = sorting.getOrder().orElse(SortOrder.ASC);
        return switch (sortOrder) {
            case SortOrder.DESC -> Comparator.comparing(switch (sortBy) {
                case "value" -> MapResultEntryDto::getValue;
                case "label" -> entry -> entry.getLabel().toLowerCase(Locale.ENGLISH);
                default -> entry -> {
                    if (entry.getKey().equals("missing")) {
                        return null;
                    }
                    try {
                        return keyIsOfNumericType ? Double.valueOf(entry.getKey()) : entry.getKey().toLowerCase(Locale.ENGLISH);
                    }
                    catch (NumberFormatException exception) {
                        throw new OptimizeRuntimeException("Error sorting numerically for key: " + entry.getKey());
                    }
                };
            }, Comparator.nullsLast(Comparator.reverseOrder()));
            default -> Comparator.comparing(switch (sortBy) {
                case "value" -> MapResultEntryDto::getValue;
                case "label" -> entry -> entry.getLabel().toLowerCase(Locale.ENGLISH);
                default -> entry -> {
                    if (entry.getKey().equals("missing")) {
                        return null;
                    }
                    try {
                        return keyIsOfNumericType ? Double.valueOf(entry.getKey()) : entry.getKey().toLowerCase(Locale.ENGLISH);
                    }
                    catch (NumberFormatException exception) {
                        throw new OptimizeRuntimeException("Error sorting numerically for key: " + entry.getKey());
                    }
                };
            }, Comparator.nullsLast(Comparator.naturalOrder()));
        };
    }

    private void sortHypermapResultData(ReportSortingDto sortingDto, boolean keyIsOfNumericType, List<HyperMapResultEntryDto> data) {
        if (data.isEmpty()) {
            return;
        }
        Optional.of(sortingDto).ifPresent(sorting -> {
            String sortBy = sorting.getBy().orElse("key");
            SortOrder sortOrder = sorting.getOrder().orElse(SortOrder.ASC);
            data.sort(switch (sortOrder) {
                case SortOrder.DESC -> Comparator.comparing(switch (sortBy) {
                    case "label" -> entry -> entry.getLabel().toLowerCase(Locale.ENGLISH);
                    default -> entry -> {
                        if (entry.getKey().equals("missing")) {
                            return null;
                        }
                        try {
                            return keyIsOfNumericType ? Double.valueOf(entry.getKey()) : entry.getKey().toLowerCase(Locale.ENGLISH);
                        }
                        catch (NumberFormatException exception) {
                            throw new OptimizeRuntimeException("Error sorting numerically for key: " + entry.getKey());
                        }
                    };
                }, Comparator.nullsLast(Comparator.reverseOrder()));
                default -> Comparator.comparing(switch (sortBy) {
                    case "label" -> entry -> entry.getLabel().toLowerCase(Locale.ENGLISH);
                    default -> entry -> {
                        if (entry.getKey().equals("missing")) {
                            return null;
                        }
                        try {
                            return keyIsOfNumericType ? Double.valueOf(entry.getKey()) : entry.getKey().toLowerCase(Locale.ENGLISH);
                        }
                        catch (NumberFormatException exception) {
                            throw new OptimizeRuntimeException("Error sorting numerically for key: " + entry.getKey());
                        }
                    };
                }, Comparator.nullsLast(Comparator.naturalOrder()));
            });
        });
    }

    private String createErrorMessage(Class<?> resultClass, Class<?> resultPartClass) {
        return String.format("Could not transform the result of command to a %s since the result has not the right structure. For %s the %s result is supposed to contain just one value!", resultClass.getSimpleName(), resultClass.getSimpleName(), resultPartClass.getSimpleName());
    }

    public SingleReportDataDto getReportDataDto() {
        return this.reportDataDto;
    }

    public ViewProperty getViewProperty() {
        return this.viewProperty;
    }

    public ReportSortingDto getGroupBySorting() {
        return this.groupBySorting;
    }

    public void setGroupBySorting(ReportSortingDto groupBySorting) {
        this.groupBySorting = groupBySorting;
    }

    public ReportSortingDto getDistributedBySorting() {
        return this.distributedBySorting;
    }

    public void setDistributedBySorting(ReportSortingDto distributedBySorting) {
        this.distributedBySorting = distributedBySorting;
    }

    public boolean isGroupByKeyOfNumericType() {
        return this.isGroupByKeyOfNumericType;
    }

    public void setGroupByKeyOfNumericType(boolean isGroupByKeyOfNumericType) {
        this.isGroupByKeyOfNumericType = isGroupByKeyOfNumericType;
    }

    public boolean isDistributedByKeyOfNumericType() {
        return this.isDistributedByKeyOfNumericType;
    }

    public void setDistributedByKeyOfNumericType(boolean isDistributedByKeyOfNumericType) {
        this.isDistributedByKeyOfNumericType = isDistributedByKeyOfNumericType;
    }

    public Supplier<Double> getDefaultNumberValueSupplier() {
        return this.defaultNumberValueSupplier;
    }

    public void setDefaultNumberValueSupplier(Supplier<Double> defaultNumberValueSupplier) {
        this.defaultNumberValueSupplier = defaultNumberValueSupplier;
    }

    public List<GroupByResult> getGroups() {
        return this.groups;
    }

    public void setGroups(List<GroupByResult> groups) {
        this.groups = groups;
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompositeCommandResult;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return "CompositeCommandResult(reportDataDto=" + String.valueOf(this.getReportDataDto()) + ", viewProperty=" + String.valueOf(this.getViewProperty()) + ", groupBySorting=" + String.valueOf(this.getGroupBySorting()) + ", distributedBySorting=" + String.valueOf(this.getDistributedBySorting()) + ", isGroupByKeyOfNumericType=" + this.isGroupByKeyOfNumericType() + ", isDistributedByKeyOfNumericType=" + this.isDistributedByKeyOfNumericType() + ", defaultNumberValueSupplier=" + String.valueOf(this.getDefaultNumberValueSupplier()) + ", groups=" + String.valueOf(this.getGroups()) + ")";
    }

    private static /* synthetic */ void lambda$createMeasureMap$12(Map measureMap, UserTaskDurationTime userTaskDurationTime, Supplier defaultValueSupplier, AggregationDto aggregationType) {
        measureMap.put(new ViewMeasureIdentifier(aggregationType, userTaskDurationTime), defaultValueSupplier.get());
    }

    public static class GroupByResult {
        private String key;
        private String label;
        private List<DistributedByResult> distributions;

        protected GroupByResult(String key, String label, List<DistributedByResult> distributions) {
            this.key = key;
            this.label = label;
            this.distributions = distributions;
        }

        public static GroupByResult createGroupByNone(List<DistributedByResult> distributions) {
            return new GroupByResult("____none", null, distributions);
        }

        public static GroupByResult createGroupByResult(String key, String label, DistributedByResult distribution) {
            return new GroupByResult(key, label, Collections.singletonList(distribution));
        }

        public static GroupByResult createGroupByResult(String key, List<DistributedByResult> distributions) {
            return new GroupByResult(key, null, distributions);
        }

        public static GroupByResult createGroupByResult(String key, String label, List<DistributedByResult> distributions) {
            return new GroupByResult(key, label, distributions);
        }

        public String getLabel() {
            return !StringUtils.isEmpty((CharSequence)this.label) ? this.label : this.key;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public List<DistributedByResult> getDistributions() {
            return this.distributions;
        }

        public void setDistributions(List<DistributedByResult> distributions) {
            this.distributions = distributions;
        }

        protected boolean canEqual(Object other) {
            return other instanceof GroupByResult;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
        }

        public String toString() {
            return "CompositeCommandResult.GroupByResult(key=" + this.getKey() + ", label=" + this.getLabel() + ", distributions=" + String.valueOf(this.getDistributions()) + ")";
        }
    }

    public static class DistributedByResult {
        private String key;
        private String label;
        private ViewResult viewResult;

        protected DistributedByResult(String key, String label, ViewResult viewResult) {
            this.key = key;
            this.label = label;
            this.viewResult = viewResult;
        }

        public static DistributedByResult createDistributedByNoneResult(ViewResult viewResult) {
            return new DistributedByResult(null, null, viewResult);
        }

        public static DistributedByResult createDistributedByResult(String key, String label, ViewResult viewResult) {
            return new DistributedByResult(key, label, viewResult);
        }

        public String getLabel() {
            return this.label != null && !this.label.isEmpty() ? this.label : this.key;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public List<Double> getValuesAsDouble() {
            return this.getViewResult().getViewMeasures().stream().map(ViewMeasure::getValue).collect(Collectors.toList());
        }

        public List<MapResultEntryDto> getValuesAsMapResultEntries() {
            return this.getValuesAsDouble().stream().map(value -> new MapResultEntryDto(this.key, value, this.label)).collect(Collectors.toList());
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public ViewResult getViewResult() {
            return this.viewResult;
        }

        public void setViewResult(ViewResult viewResult) {
            this.viewResult = viewResult;
        }

        protected boolean canEqual(Object other) {
            return other instanceof DistributedByResult;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
        }

        public String toString() {
            return "CompositeCommandResult.DistributedByResult(key=" + this.getKey() + ", label=" + this.getLabel() + ", viewResult=" + String.valueOf(this.getViewResult()) + ")";
        }
    }

    public static class ViewResult {
        private List<ViewMeasure> viewMeasures;
        private List<? extends RawDataInstanceDto> rawData;

        ViewResult(List<ViewMeasure> viewMeasures, List<? extends RawDataInstanceDto> rawData) {
            this.viewMeasures = viewMeasures;
            this.rawData = rawData;
        }

        public static ViewResultBuilder builder() {
            return new ViewResultBuilder();
        }

        public List<ViewMeasure> getViewMeasures() {
            return this.viewMeasures;
        }

        public void setViewMeasures(List<ViewMeasure> viewMeasures) {
            this.viewMeasures = viewMeasures;
        }

        public List<? extends RawDataInstanceDto> getRawData() {
            return this.rawData;
        }

        public void setRawData(List<? extends RawDataInstanceDto> rawData) {
            this.rawData = rawData;
        }

        protected boolean canEqual(Object other) {
            return other instanceof ViewResult;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
        }

        public String toString() {
            return "CompositeCommandResult.ViewResult(viewMeasures=" + String.valueOf(this.getViewMeasures()) + ", rawData=" + String.valueOf(this.getRawData()) + ")";
        }

        public static class ViewResultBuilder {
            private ArrayList<ViewMeasure> viewMeasures;
            private List<? extends RawDataInstanceDto> rawData;

            ViewResultBuilder() {
            }

            public ViewResultBuilder viewMeasure(ViewMeasure viewMeasure) {
                if (this.viewMeasures == null) {
                    this.viewMeasures = new ArrayList();
                }
                this.viewMeasures.add(viewMeasure);
                return this;
            }

            public ViewResultBuilder viewMeasures(Collection<? extends ViewMeasure> viewMeasures) {
                if (viewMeasures == null) {
                    throw new NullPointerException("viewMeasures cannot be null");
                }
                if (this.viewMeasures == null) {
                    this.viewMeasures = new ArrayList();
                }
                this.viewMeasures.addAll(viewMeasures);
                return this;
            }

            public ViewResultBuilder clearViewMeasures() {
                if (this.viewMeasures != null) {
                    this.viewMeasures.clear();
                }
                return this;
            }

            public ViewResultBuilder rawData(List<? extends RawDataInstanceDto> rawData) {
                this.rawData = rawData;
                return this;
            }

            public ViewResult build() {
                return new ViewResult(switch (this.viewMeasures == null ? 0 : this.viewMeasures.size()) {
                    case 0 -> Collections.emptyList();
                    case 1 -> Collections.singletonList(this.viewMeasures.get(0));
                    default -> Collections.unmodifiableList(new ArrayList<ViewMeasure>(this.viewMeasures));
                }, this.rawData);
            }

            public String toString() {
                return "CompositeCommandResult.ViewResult.ViewResultBuilder(viewMeasures=" + String.valueOf(this.viewMeasures) + ", rawData=" + String.valueOf(this.rawData) + ")";
            }
        }
    }

    public static class ViewMeasure {
        private AggregationDto aggregationType;
        private UserTaskDurationTime userTaskDurationTime;
        private Double value;

        ViewMeasure(AggregationDto aggregationType, UserTaskDurationTime userTaskDurationTime, Double value) {
            this.aggregationType = aggregationType;
            this.userTaskDurationTime = userTaskDurationTime;
            this.value = value;
        }

        public ViewMeasureIdentifier getViewMeasureIdentifier() {
            return new ViewMeasureIdentifier(this.aggregationType, this.userTaskDurationTime);
        }

        public static ViewMeasureBuilder builder() {
            return new ViewMeasureBuilder();
        }

        public AggregationDto getAggregationType() {
            return this.aggregationType;
        }

        public void setAggregationType(AggregationDto aggregationType) {
            this.aggregationType = aggregationType;
        }

        public UserTaskDurationTime getUserTaskDurationTime() {
            return this.userTaskDurationTime;
        }

        public void setUserTaskDurationTime(UserTaskDurationTime userTaskDurationTime) {
            this.userTaskDurationTime = userTaskDurationTime;
        }

        public Double getValue() {
            return this.value;
        }

        public void setValue(Double value) {
            this.value = value;
        }

        protected boolean canEqual(Object other) {
            return other instanceof ViewMeasure;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
        }

        public String toString() {
            return "CompositeCommandResult.ViewMeasure(aggregationType=" + String.valueOf(this.getAggregationType()) + ", userTaskDurationTime=" + String.valueOf(this.getUserTaskDurationTime()) + ", value=" + this.getValue() + ")";
        }

        public static class ViewMeasureBuilder {
            private AggregationDto aggregationType;
            private UserTaskDurationTime userTaskDurationTime;
            private Double value;

            ViewMeasureBuilder() {
            }

            public ViewMeasureBuilder aggregationType(AggregationDto aggregationType) {
                this.aggregationType = aggregationType;
                return this;
            }

            public ViewMeasureBuilder userTaskDurationTime(UserTaskDurationTime userTaskDurationTime) {
                this.userTaskDurationTime = userTaskDurationTime;
                return this;
            }

            public ViewMeasureBuilder value(Double value) {
                this.value = value;
                return this;
            }

            public ViewMeasure build() {
                return new ViewMeasure(this.aggregationType, this.userTaskDurationTime, this.value);
            }

            public String toString() {
                return "CompositeCommandResult.ViewMeasure.ViewMeasureBuilder(aggregationType=" + String.valueOf(this.aggregationType) + ", userTaskDurationTime=" + String.valueOf(this.userTaskDurationTime) + ", value=" + this.value + ")";
            }
        }
    }

    public static class ViewMeasureIdentifier {
        private AggregationDto aggregationType;
        private UserTaskDurationTime userTaskDurationTime;

        public ViewMeasureIdentifier(AggregationDto aggregationDto) {
            this.aggregationType = aggregationDto;
        }

        public ViewMeasureIdentifier(AggregationDto aggregationType, UserTaskDurationTime userTaskDurationTime) {
            this.aggregationType = aggregationType;
            this.userTaskDurationTime = userTaskDurationTime;
        }

        public ViewMeasureIdentifier() {
        }

        public AggregationDto getAggregationType() {
            return this.aggregationType;
        }

        public void setAggregationType(AggregationDto aggregationType) {
            this.aggregationType = aggregationType;
        }

        public UserTaskDurationTime getUserTaskDurationTime() {
            return this.userTaskDurationTime;
        }

        public void setUserTaskDurationTime(UserTaskDurationTime userTaskDurationTime) {
            this.userTaskDurationTime = userTaskDurationTime;
        }

        protected boolean canEqual(Object other) {
            return other instanceof ViewMeasureIdentifier;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
        }

        public boolean equals(Object o) {
            return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
        }

        public String toString() {
            return "CompositeCommandResult.ViewMeasureIdentifier(aggregationType=" + String.valueOf(this.getAggregationType()) + ", userTaskDurationTime=" + String.valueOf(this.getUserTaskDurationTime()) + ")";
        }
    }
}

