/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.plan.decision;

import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.service.db.report.plan.ExecutionPlan;
import io.camunda.optimize.service.db.report.plan.ReportResultType;
import io.camunda.optimize.service.db.report.plan.decision.DecisionDistributedBy;
import io.camunda.optimize.service.db.report.plan.decision.DecisionGroupBy;
import io.camunda.optimize.service.db.report.plan.decision.DecisionView;

public enum DecisionExecutionPlan implements ExecutionPlan
{
    DECISION_INSTANCE_FREQUENCY_GROUP_BY_EVALUATION_DATE_TIME(DecisionView.DECISION_VIEW_INSTANCE_FREQUENCY, DecisionGroupBy.DECISION_GROUP_BY_EVALUATION_DATE_TIME, DecisionDistributedBy.DECISION_DISTRIBUTED_BY_NONE, ReportResultType.MAP),
    DECISION_INSTANCE_FREQUENCY_GROUP_BY_INPUT_VARIABLE(DecisionView.DECISION_VIEW_INSTANCE_FREQUENCY, DecisionGroupBy.DECISION_GROUP_BY_INPUT_VARIABLE, DecisionDistributedBy.DECISION_DISTRIBUTED_BY_NONE, ReportResultType.MAP),
    DECISION_INSTANCE_FREQUENCY_GROUP_BY_MATCHED_RULE(DecisionView.DECISION_VIEW_INSTANCE_FREQUENCY, DecisionGroupBy.DECISION_GROUP_BY_MATCHED_RULE, DecisionDistributedBy.DECISION_DISTRIBUTED_BY_NONE, ReportResultType.MAP),
    DECISION_INSTANCE_FREQUENCY_GROUP_BY_NONE(DecisionView.DECISION_VIEW_INSTANCE_FREQUENCY, DecisionGroupBy.DECISION_GROUP_BY_NONE, DecisionDistributedBy.DECISION_DISTRIBUTED_BY_NONE, ReportResultType.NUMBER),
    DECISION_INSTANCE_FREQUENCY_GROUP_BY_OUTPUT_VARIABLE(DecisionView.DECISION_VIEW_INSTANCE_FREQUENCY, DecisionGroupBy.DECISION_GROUP_BY_OUTPUT_VARIABLE, DecisionDistributedBy.DECISION_DISTRIBUTED_BY_NONE, ReportResultType.MAP),
    DECISION_RAW_DECISION_INSTANCE_DATA_GROUP_BY_NONE(DecisionView.DECISION_VIEW_RAW_DATA, DecisionGroupBy.DECISION_GROUP_BY_NONE, DecisionDistributedBy.DECISION_DISTRIBUTED_BY_NONE, ReportResultType.RAW_DATA);

    private final DecisionView view;
    private final DecisionGroupBy groupBy;
    private final DecisionDistributedBy distributedBy;
    private final ReportResultType resultType;
    private final String commandKey;

    private DecisionExecutionPlan(DecisionView view, DecisionGroupBy groupBy, DecisionDistributedBy distributedBy, ReportResultType resultType) {
        this.view = view;
        this.groupBy = groupBy;
        this.distributedBy = distributedBy;
        this.resultType = resultType;
        this.commandKey = this.buildCommandKey();
    }

    private DecisionExecutionPlan(DecisionView view, DecisionGroupBy groupBy, DecisionDistributedBy distributedBy, ReportResultType resultType, String commandKey) {
        this.view = view;
        this.groupBy = groupBy;
        this.distributedBy = distributedBy;
        this.resultType = resultType;
        this.commandKey = commandKey;
    }

    @Override
    public boolean isRawDataReport() {
        return this.resultType == ReportResultType.RAW_DATA;
    }

    private String buildCommandKey() {
        DecisionReportDataDto decisionReportDataDto = DecisionReportDataDto.builder().groupBy(this.groupBy.getDto()).distributedBy(this.distributedBy.getDto()).view(this.view.getDecisionViewDto()).build();
        return (String)decisionReportDataDto.createCommandKeys().get(0);
    }

    public DecisionView getView() {
        return this.view;
    }

    public DecisionGroupBy getGroupBy() {
        return this.groupBy;
    }

    public DecisionDistributedBy getDistributedBy() {
        return this.distributedBy;
    }

    public ReportResultType getResultType() {
        return this.resultType;
    }

    @Override
    public String getCommandKey() {
        return this.commandKey;
    }
}

