/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter.view.process;

import io.camunda.optimize.dto.optimize.query.report.single.ReportDataDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.configuration.TableColumnDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.result.raw.RawDataProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.view.ViewInterpreter;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessView;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.export.CSVUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractProcessViewRawDataInterpreter
implements ViewInterpreter<ProcessReportDataDto, ProcessExecutionPlan> {
    public static final String SORT_SCRIPT = "if (doc[params.duration].size() == 0) {\n  params.currentTime - doc[params.startDate].value.toInstant().toEpochMilli()\n} else {\n   doc[params.duration].value\n}\n";
    public static final String NUMBER_OF_USER_TASKS_SCRIPT = "Optional.ofNullable(params._source.flowNodeInstances)\n  .map(list -> list.stream().filter(item -> item.flowNodeType.equals('userTask')).count())\n  .orElse(0L)\n";
    protected static final String CURRENT_TIME = "currentTime";
    protected static final String PARAMS_CURRENT_TIME = "params.currentTime";
    protected static final String DATE_FORMAT = "dateFormat";
    protected static final String FLOW_NODE_IDS_TO_DURATIONS = "flowNodeIdsToDurations";
    protected static final String NUMBER_OF_USER_TASKS = "numberOfUserTasks";
    protected static final String GET_FLOW_NODE_DURATIONS_SCRIPT = "def flowNodeInstanceIdToDuration = new HashMap();\ndef dateFormatter = new SimpleDateFormat(params.dateFormat);\nfor (flowNodeInstance in params._source.flowNodeInstances) {\n  if (flowNodeInstance.totalDurationInMs != null) {\n    if (flowNodeInstanceIdToDuration.containsKey(flowNodeInstance.flowNodeId)) {\n      def currentDuration = flowNodeInstanceIdToDuration.get(flowNodeInstance.flowNodeId);\n      flowNodeInstanceIdToDuration.put(flowNodeInstance.flowNodeId, flowNodeInstance.totalDurationInMs + currentDuration)\n    } else {\n      flowNodeInstanceIdToDuration.put(flowNodeInstance.flowNodeId, flowNodeInstance.totalDurationInMs)\n    }\n  } else {\n    if (flowNodeInstance.startDate != null) {\n      def duration = params.currentTime - dateFormatter.parse(flowNodeInstance.startDate).getTime();\n      if (flowNodeInstanceIdToDuration.containsKey(flowNodeInstance.flowNodeId)) {\n        def currentDuration = flowNodeInstanceIdToDuration.get(flowNodeInstance.flowNodeId);\n        flowNodeInstanceIdToDuration.put(flowNodeInstance.flowNodeId, duration + currentDuration)\n      } else {\n        flowNodeInstanceIdToDuration.put(flowNodeInstance.flowNodeId, duration)\n      }\n    }\n  }\n}\nreturn flowNodeInstanceIdToDuration;\n";

    public Set<ProcessView> getSupportedViews() {
        return Set.of(ProcessView.PROCESS_VIEW_RAW_DATA);
    }

    @Override
    public CompositeCommandResult.ViewResult createEmptyResult(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return CompositeCommandResult.ViewResult.builder().rawData(new ArrayList()).build();
    }

    protected void addNewVariablesAndDtoFieldsToTableColumnConfig(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, List<RawDataProcessInstanceDto> rawData) {
        List<String> variableNames = rawData.stream().flatMap(rawDataProcessInstanceDto -> rawDataProcessInstanceDto.getVariables().keySet().stream()).map(varKey -> "variable:" + varKey).toList();
        TableColumnDto tableColumns = context.getReportConfiguration().getTableColumns();
        tableColumns.addCountColumns(CSVUtils.extractAllPrefixedCountKeys());
        tableColumns.addNewAndRemoveUnexpectedVariableColumns(variableNames);
        tableColumns.addNewAndRemoveUnexpectedFlowNodeDurationColumns(CSVUtils.extractAllPrefixedFlowNodeKeys(rawData));
        tableColumns.addDtoColumns(CSVUtils.extractAllProcessInstanceDtoFieldKeys());
    }

    protected List<String> defKeysToTarget(List<ReportDataDefinitionDto> definitions) {
        return definitions.stream().map(ReportDataDefinitionDto::getKey).filter(Objects::nonNull).toList();
    }

    protected String sortByField(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return context.getReportConfiguration().getSorting().flatMap(ReportSortingDto::getBy).orElse("startDate");
    }
}

