/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.FlowNodeTotalDurationDataDto;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.datasource.DataSourceDto;
import io.camunda.optimize.dto.optimize.persistence.incident.IncidentStatus;
import io.camunda.optimize.dto.optimize.query.process.FlowNodeInstanceDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.result.raw.RawDataCountDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.result.raw.RawDataFlowNodeDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.result.raw.RawDataProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.variable.SimpleProcessVariableDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawProcessDataResultDtoMapper {
    public static final String OBJECT_VARIABLE_VALUE_PLACEHOLDER = "<<OBJECT_VARIABLE_VALUE>>";
    private static final String DEFAULT_VARIABLE_VALUE = "";
    private static final Logger LOG = LoggerFactory.getLogger(RawProcessDataResultDtoMapper.class);

    public List<RawDataProcessInstanceDto> mapFrom(List<ProcessInstanceDto> processInstanceDtos, ObjectMapper objectMapper, Set<String> allVariableNames, Map<String, Long> instanceIdsToUserTaskCount, Map<String, Map<String, Long>> processInstanceIdsToFlowNodeDurations, Map<String, String> flowNodeIdsToFlowNodeNames) {
        ArrayList<RawDataProcessInstanceDto> rawData = new ArrayList<RawDataProcessInstanceDto>();
        processInstanceDtos.forEach(processInstanceDto -> {
            Map<String, Object> variables = this.getVariables((ProcessInstanceDto)processInstanceDto, objectMapper);
            allVariableNames.addAll(variables.keySet());
            RawDataProcessInstanceDto dataEntry = this.convertToRawDataEntry((ProcessInstanceDto)processInstanceDto, variables, instanceIdsToUserTaskCount, this.convertToFlowNodeDurationDataDto(processInstanceIdsToFlowNodeDurations.getOrDefault(processInstanceDto.getProcessInstanceId(), Collections.emptyMap()), flowNodeIdsToFlowNodeNames), flowNodeIdsToFlowNodeNames);
            rawData.add(dataEntry);
        });
        this.ensureEveryRawDataInstanceContainsAllVariableNames(rawData, allVariableNames);
        return rawData;
    }

    private void ensureEveryRawDataInstanceContainsAllVariableNames(List<RawDataProcessInstanceDto> rawData, Set<String> allVariableNames) {
        rawData.forEach(data -> allVariableNames.forEach(varName -> data.getVariables().putIfAbsent(varName, DEFAULT_VARIABLE_VALUE)));
    }

    private RawDataProcessInstanceDto convertToRawDataEntry(ProcessInstanceDto processInstanceDto, Map<String, Object> variables, Map<String, Long> instanceIdsToUserTaskCount, Map<String, FlowNodeTotalDurationDataDto> flowNodeIdsToDurations, Map<String, String> flowNodeIdsToFlowNodeNames) {
        RawDataCountDto rawDataCountDto = new RawDataCountDto();
        rawDataCountDto.setIncidents((long)processInstanceDto.getIncidents().size());
        rawDataCountDto.setOpenIncidents(processInstanceDto.getIncidents().stream().filter(incidentDto -> incidentDto.getIncidentStatus() == IncidentStatus.OPEN).count());
        rawDataCountDto.setUserTasks(instanceIdsToUserTaskCount.getOrDefault(processInstanceDto.getProcessInstanceId(), 0L).longValue());
        return new RawDataProcessInstanceDto(processInstanceDto.getProcessDefinitionKey(), processInstanceDto.getProcessDefinitionId(), processInstanceDto.getProcessInstanceId(), rawDataCountDto, flowNodeIdsToDurations, processInstanceDto.getBusinessKey(), processInstanceDto.getStartDate(), processInstanceDto.getEndDate(), processInstanceDto.getDuration(), (String)Optional.ofNullable(processInstanceDto.getDataSource()).map(DataSourceDto::getName).orElse(null), processInstanceDto.getTenantId(), variables, processInstanceDto.getFlowNodeInstances().stream().map(flowNodeInstance -> new RawDataFlowNodeDataDto(flowNodeInstance.getFlowNodeInstanceId(), Optional.ofNullable((String)flowNodeIdsToFlowNodeNames.get(flowNodeInstance.getFlowNodeId())).orElseGet(() -> ((FlowNodeInstanceDto)flowNodeInstance).getFlowNodeId()), flowNodeInstance.getStartDate(), flowNodeInstance.getEndDate())).toList());
    }

    private Map<String, Object> getVariables(ProcessInstanceDto processInstanceDto, ObjectMapper objectMapper) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (SimpleProcessVariableDto variableInstance : processInstanceDto.getVariables()) {
            if (variableInstance.getName() != null) {
                if (VariableType.OBJECT.getId().equalsIgnoreCase(variableInstance.getType())) {
                    result.put(variableInstance.getName(), OBJECT_VARIABLE_VALUE_PLACEHOLDER);
                    continue;
                }
                result.put(variableInstance.getName(), Optional.ofNullable(variableInstance.getValue()).map(value -> String.join((CharSequence)", ", value)).orElse(DEFAULT_VARIABLE_VALUE));
                continue;
            }
            try {
                LOG.debug("Found variable with null name [{}]", (Object)objectMapper.writeValueAsString((Object)variableInstance));
            }
            catch (JsonProcessingException jsonProcessingException) {}
        }
        return result;
    }

    private Map<String, FlowNodeTotalDurationDataDto> convertToFlowNodeDurationDataDto(Map<String, Long> flowNodeIdsToDurations, Map<String, String> flowNodeIdsToFlowNodeNames) {
        return flowNodeIdsToDurations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, flowNodeIdToDuration -> new FlowNodeTotalDurationDataDto((String)flowNodeIdsToFlowNodeNames.get(flowNodeIdToDuration.getKey()), ((Number)flowNodeIdToDuration.getValue()).longValue())));
    }
}

