/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter.service;

import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.report.MinMaxStatDto;
import io.camunda.optimize.service.db.report.context.VariableAggregationContext;
import io.camunda.optimize.service.util.RoundingUtil;
import java.util.Optional;

public class AbstractNumberVariableAggregationService {
    protected Double getIntervalSize(VariableAggregationContext context, Double baseline) {
        double maxVariableValue = context.getMaxVariableValue();
        boolean customBucketsActive = context.getCustomBucketDto().isActive();
        Double intervalSize = context.getCustomBucketDto().getBucketSize();
        if (!customBucketsActive || intervalSize == null || intervalSize <= 0.0) {
            intervalSize = Math.abs(maxVariableValue - baseline) / 79.0;
            intervalSize = intervalSize == 0.0 ? 1.0 : RoundingUtil.roundUpToNearestPowerOfTen(intervalSize);
        }
        if (!VariableType.DOUBLE.equals((Object)context.getVariableType())) {
            intervalSize = Math.ceil(intervalSize);
        }
        return intervalSize;
    }

    public Optional<Double> getBaselineForNumberVariableAggregation(VariableAggregationContext context) {
        Optional<Double> baselineForSingleReport;
        Optional<MinMaxStatDto> combinedMinMaxStats = context.getCombinedRangeMinMaxStats();
        Optional<Double> optional = baselineForSingleReport = context.getCustomBucketDto().isActive() ? Optional.ofNullable(context.getCustomBucketDto().getBaseline()) : Optional.empty();
        if (combinedMinMaxStats.isEmpty() && baselineForSingleReport.isPresent()) {
            if ((Double)baselineForSingleReport.get() > context.getVariableRangeMinMaxStats().getMax()) {
                return Optional.empty();
            }
            return baselineForSingleReport;
        }
        return Optional.of(RoundingUtil.roundDownToNearestPowerOfTen(combinedMinMaxStats.orElse(context.getVariableRangeMinMaxStats()).getMin()));
    }
}

