/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.interpreter.groupby.process.identity;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.IdentityType;
import io.camunda.optimize.dto.optimize.IdentityWithMetadataResponseDto;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.AssigneeCandidateGroupService;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.LocalizationService;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.stereotype.Component;

@Component
public class ProcessGroupByIdentityInterpreterHelper {
    private final DefinitionService definitionService;
    private final LocalizationService localizationService;
    private final AssigneeCandidateGroupService assigneeCandidateGroupService;

    public ProcessGroupByIdentityInterpreterHelper(DefinitionService definitionService, LocalizationService localizationService, AssigneeCandidateGroupService assigneeCandidateGroupService) {
        this.definitionService = definitionService;
        this.localizationService = localizationService;
        this.assigneeCandidateGroupService = assigneeCandidateGroupService;
    }

    public Set<String> getUserTaskIds(ProcessReportDataDto reportData) {
        return this.definitionService.extractUserTaskIdAndNames(reportData.getDefinitions().stream().map(definitionDto -> this.definitionService.getDefinition(DefinitionType.PROCESS, definitionDto.getKey(), definitionDto.getVersions(), definitionDto.getTenantIds())).filter(Optional::isPresent).map(Optional::get).map(ProcessDefinitionOptimizeDto.class::cast).toList()).keySet();
    }

    public String resolveIdentityName(String key, Supplier<IdentityType> identityTypeSupplier) {
        return "unassignedUserTasks___".equals(key) ? this.localizationService.getDefaultLocaleMessageForMissingAssigneeLabel() : this.assigneeCandidateGroupService.getIdentityByIdAndType(key, identityTypeSupplier.get()).map(IdentityWithMetadataResponseDto::getName).orElse(key);
    }
}

