/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.report.groupby.flownode;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.filter.FilterApplicationLevel;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class GroupByIncidentFlowNodeInterpreterHelper {
    private final DefinitionService definitionService;

    public GroupByIncidentFlowNodeInterpreterHelper(DefinitionService definitionService) {
        this.definitionService = definitionService;
    }

    public static void addMissingGroupByIncidentKeys(Map<String, String> flowNodeNames, List<CompositeCommandResult.GroupByResult> groupedData, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, List<CompositeCommandResult.DistributedByResult> emptyDistributedByResult) {
        boolean viewLevelFilterExists = context.getReportData().getFilter().stream().anyMatch(filter -> FilterApplicationLevel.VIEW.equals((Object)filter.getFilterLevel()));
        if (!viewLevelFilterExists) {
            flowNodeNames.keySet().forEach(flowNodeKey -> {
                CompositeCommandResult.GroupByResult emptyResult = CompositeCommandResult.GroupByResult.createGroupByResult(flowNodeKey, (String)flowNodeNames.get(flowNodeKey), emptyDistributedByResult);
                groupedData.add(emptyResult);
            });
        }
    }

    public Map<String, String> getFlowNodeNames(ProcessReportDataDto reportData) {
        return this.definitionService.extractFlowNodeIdAndNames(reportData.getDefinitions().stream().map(definitionDto -> this.definitionService.getDefinition(DefinitionType.PROCESS, definitionDto.getKey(), definitionDto.getVersions(), definitionDto.getTenantIds())).filter(Optional::isPresent).map(Optional::get).map(ProcessDefinitionOptimizeDto.class::cast).collect(Collectors.toList()));
    }
}

