/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.writer;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.query.IdResponseDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionUpdateDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.combined.CombinedReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.SingleDecisionReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.SingleDecisionReportDefinitionUpdateDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionUpdateDto;
import io.camunda.optimize.rest.exceptions.NotFoundException;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.writer.OpenSearchWriterUtil;
import io.camunda.optimize.service.db.writer.DatabaseWriterUtil;
import io.camunda.optimize.service.db.writer.ReportWriter;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.IdGenerator;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import jakarta.json.JsonValue;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.Result;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.NestedQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.DeleteRequest;
import org.opensearch.client.opensearch.core.DeleteResponse;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.UpdateResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ReportWriterOS
implements ReportWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ReportWriterOS.class);
    private final ObjectMapper objectMapper;
    private final OptimizeOpenSearchClient osClient;

    public ReportWriterOS(ObjectMapper objectMapper, OptimizeOpenSearchClient osClient) {
        this.objectMapper = objectMapper;
        this.osClient = osClient;
    }

    @Override
    public IdResponseDto createNewCombinedReport(String userId, CombinedReportDataDto reportData, String reportName, String description, String collectionId) {
        if (userId == null) {
            throw new OptimizeRuntimeException("userId is null");
        }
        if (reportData == null) {
            throw new OptimizeRuntimeException("reportData is null");
        }
        if (reportName == null) {
            throw new OptimizeRuntimeException("reportName is null");
        }
        LOG.debug("Writing new combined report to OpenSearch");
        String id = IdGenerator.getNextId();
        CombinedReportDefinitionRequestDto reportDefinitionDto = new CombinedReportDefinitionRequestDto();
        reportDefinitionDto.setId(id);
        OffsetDateTime now = LocalDateUtil.getCurrentDateTime();
        reportDefinitionDto.setCreated(now);
        reportDefinitionDto.setLastModified(now);
        reportDefinitionDto.setOwner(userId);
        reportDefinitionDto.setLastModifier(userId);
        reportDefinitionDto.setName(reportName);
        reportDefinitionDto.setDescription(description);
        reportDefinitionDto.setData((ReportDataDto)reportData);
        reportDefinitionDto.setCollectionId(collectionId);
        IndexRequest.Builder request = new IndexRequest.Builder().index("combined-report").id(id).document((Object)reportDefinitionDto).refresh(Refresh.True);
        IndexResponse indexResponse = this.osClient.index(request);
        if (!indexResponse.result().equals((Object)Result.Created)) {
            String message = String.format("Could not write report with id [%s] and name [%s] to OpenSearch.", id, reportName);
            LOG.error(message);
            throw new OptimizeRuntimeException(message);
        }
        LOG.debug("Report with id [{}] has successfully been created.", (Object)id);
        return new IdResponseDto(id);
    }

    @Override
    public IdResponseDto createNewSingleProcessReport(String userId, ProcessReportDataDto reportData, String reportName, String description, String collectionId) {
        if (reportData == null) {
            throw new OptimizeRuntimeException("reportData is null");
        }
        if (reportName == null) {
            throw new OptimizeRuntimeException("reportName is null");
        }
        LOG.debug("Writing new single report to OpenSearch");
        String id = IdGenerator.getNextId();
        SingleProcessReportDefinitionRequestDto reportDefinitionDto = new SingleProcessReportDefinitionRequestDto();
        reportDefinitionDto.setId(id);
        OffsetDateTime now = LocalDateUtil.getCurrentDateTime();
        reportDefinitionDto.setCreated(now);
        reportDefinitionDto.setLastModified(now);
        reportDefinitionDto.setOwner(userId);
        reportDefinitionDto.setLastModifier(userId);
        reportDefinitionDto.setName(reportName);
        reportDefinitionDto.setDescription(description);
        reportDefinitionDto.setData((ReportDataDto)reportData);
        reportDefinitionDto.setCollectionId(collectionId);
        IndexRequest.Builder request = new IndexRequest.Builder().index("single-process-report").id(id).document((Object)reportDefinitionDto).refresh(Refresh.True);
        IndexResponse indexResponse = this.osClient.index(request);
        if (!indexResponse.result().equals((Object)Result.Created)) {
            String message = String.format("Could not write single process report with id [%s] and name [%s] to OpenSearch.", id, reportName);
            LOG.error(message);
            throw new OptimizeRuntimeException(message);
        }
        LOG.debug("Single process report with id [{}] has successfully been created.", (Object)id);
        return new IdResponseDto(id);
    }

    @Override
    public IdResponseDto createNewSingleDecisionReport(String userId, DecisionReportDataDto reportData, String reportName, String description, String collectionId) {
        if (userId == null) {
            throw new OptimizeRuntimeException("userId is null");
        }
        if (reportData == null) {
            throw new OptimizeRuntimeException("reportData is null");
        }
        if (reportName == null) {
            throw new OptimizeRuntimeException("reportName is null");
        }
        LOG.debug("Writing new single report to OpenSearch");
        String id = IdGenerator.getNextId();
        SingleDecisionReportDefinitionRequestDto reportDefinitionDto = new SingleDecisionReportDefinitionRequestDto();
        reportDefinitionDto.setId(id);
        OffsetDateTime now = LocalDateUtil.getCurrentDateTime();
        reportDefinitionDto.setCreated(now);
        reportDefinitionDto.setLastModified(now);
        reportDefinitionDto.setOwner(userId);
        reportDefinitionDto.setLastModifier(userId);
        reportDefinitionDto.setName(reportName);
        reportDefinitionDto.setDescription(description);
        reportDefinitionDto.setData((ReportDataDto)reportData);
        reportDefinitionDto.setCollectionId(collectionId);
        IndexRequest.Builder request = new IndexRequest.Builder().index("single-decision-report").id(id).document((Object)reportDefinitionDto).refresh(Refresh.True);
        IndexResponse indexResponse = this.osClient.index(request);
        if (!indexResponse.result().equals((Object)Result.Created)) {
            String message = String.format("Could not write single decision report with id [%s] and name [%s] to OpenSearch.", id, reportName);
            LOG.error(message);
            throw new OptimizeRuntimeException(message);
        }
        LOG.debug("Single decision report with id [{}] has successfully been created.", (Object)id);
        return new IdResponseDto(id);
    }

    @Override
    public void updateSingleProcessReport(SingleProcessReportDefinitionUpdateDto reportUpdate) {
        this.updateReport((ReportDefinitionUpdateDto)reportUpdate, "single-process-report");
    }

    @Override
    public void updateSingleDecisionReport(SingleDecisionReportDefinitionUpdateDto reportUpdate) {
        this.updateReport((ReportDefinitionUpdateDto)reportUpdate, "single-decision-report");
    }

    @Override
    public void updateCombinedReport(ReportDefinitionUpdateDto updatedReport) {
        this.updateReport(updatedReport, "combined-report");
    }

    @Override
    public void updateProcessDefinitionXmlForProcessReportsWithKey(String definitionKey, String definitionXml) {
        String updateItem = String.format("reports with definitionKey [%s]", definitionKey);
        LOG.debug("Updating definition XML in {} in OpenSearch", (Object)updateItem);
        Script updateDefinitionXmlScript = OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams("ctx._source.data.configuration.xml = params.newXml;", Collections.singletonMap("newXml", JsonData.of((Object)definitionXml)));
        this.osClient.updateByQuery("single-process-report", QueryDSL.term((String)PROCESS_DEFINITION_PROPERTY, (String)definitionKey), updateDefinitionXmlScript);
    }

    @Override
    public void deleteAllManagementReports() {
        this.osClient.deleteByQuery(QueryDSL.term((String)"data.managementReport", (boolean)true), true, new String[]{"single-process-report"});
    }

    @Override
    public void deleteSingleReport(String reportId) {
        this.osClient.deleteByQuery(QueryDSL.ids((String[])new String[]{reportId}), true, new String[]{"single-process-report", "single-decision-report"});
    }

    @Override
    public void removeSingleReportFromCombinedReports(String reportId) {
        String updateItemName = String.format("report with ID [%s]", reportId);
        LOG.info("Removing {} from combined report.", (Object)updateItemName);
        Script removeReportIdFromCombinedReportsScript = OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams("def reports = ctx._source.data.reports;if(reports != null) {  reports.removeIf(r -> r.id.equals(params.idToRemove)); }", Collections.singletonMap("idToRemove", JsonData.of((Object)reportId)));
        Query nested = new NestedQuery.Builder().path(String.join((CharSequence)".", "data", "reports")).query(QueryDSL.term((String)String.join((CharSequence)".", "data", "reports", "id"), (String)reportId)).scoreMode(ChildScoreMode.None).build().toQuery();
        Query query = new NestedQuery.Builder().path("data").query(nested).scoreMode(ChildScoreMode.None).build().toQuery();
        this.osClient.updateByQuery("combined-report", query, removeReportIdFromCombinedReportsScript);
    }

    @Override
    public void deleteCombinedReport(String reportId) {
        LOG.debug("Deleting combined report with id [{}]", (Object)reportId);
        DeleteRequest.Builder requestBuilder = new DeleteRequest.Builder().index("combined-report").id(reportId).refresh(Refresh.True);
        String reason = String.format("Could not delete combined report with id [%s].", reportId);
        DeleteResponse deleteResponse = this.osClient.delete(requestBuilder, reason);
        if (!deleteResponse.result().equals((Object)Result.Deleted)) {
            String message = String.format("Could not delete combined process report with id [%s]. Combined process report does not exist.Maybe it was already deleted by someone else?", reportId);
            LOG.error(message);
            throw new NotFoundException(message);
        }
    }

    @Override
    public void deleteAllReportsOfCollection(String collectionId) {
        this.osClient.deleteByQuery(QueryDSL.term((String)"collectionId", (String)collectionId), true, new String[]{"combined-report", "single-process-report", "single-decision-report"});
    }

    private void updateReport(ReportDefinitionUpdateDto updatedReport, String indexName) {
        LOG.debug("Updating report with id [{}] in OpenSearch", (Object)updatedReport.getId());
        Map<String, JsonData> updateParams = OpenSearchWriterUtil.createFieldUpdateScriptParams(UPDATABLE_FIELDS, updatedReport, this.objectMapper);
        JsonData descriptionJson = updatedReport.getDescription() == null ? JsonData.of((Object)JsonValue.NULL) : JsonData.of((Object)updatedReport.getDescription());
        updateParams.put("description", descriptionJson);
        Script updateScript = OpenSearchWriterUtil.createDefaultScriptWithPrimitiveParams(DatabaseWriterUtil.createUpdateFieldsScript(updateParams.keySet()), updateParams);
        UpdateRequest.Builder request = new UpdateRequest.Builder().index(indexName).id(updatedReport.getId()).script(updateScript).refresh(Refresh.True).retryOnConflict(Integer.valueOf(5));
        String errorMessage = String.format("Was not able to update report with id [%s] and name [%s]", updatedReport.getId(), updatedReport.getName());
        UpdateResponse updateResponse = this.osClient.update(request, errorMessage);
        if (updateResponse.shards().failed().intValue() > 0) {
            LOG.error("Was not able to update report with id [{}] and name [{}].", (Object)updatedReport.getId(), (Object)updatedReport.getName());
            throw new OptimizeRuntimeException("Was not able to update collection!");
        }
    }
}

