/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.view.process.duration;

import io.camunda.optimize.dto.optimize.query.report.single.configuration.UserTaskDurationTime;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.os.report.aggregations.AggregationStrategyOS;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.util.DurationScriptUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.AbstractProcessViewMultiAggregationInterpreterOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessView;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import io.camunda.optimize.util.types.MapUtil;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.util.Precision;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
@Conditional(value={OpenSearchCondition.class})
public class ProcessViewUserTaskDurationInterpreterOS
extends AbstractProcessViewMultiAggregationInterpreterOS {
    @Override
    public Set<ProcessView> getSupportedViews() {
        return Set.of(ProcessView.PROCESS_VIEW_USER_TASK_DURATION);
    }

    @Override
    public Map<String, Aggregation> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return (Map)context.getReportData().getConfiguration().getUserTaskDurationTimes().stream().flatMap(userTaskDurationTime -> this.getAggregationStrategies((ProcessReportDataDto)context.getReportData()).stream().map(strategy -> strategy.createAggregation(userTaskDurationTime.getId(), this.getScriptedAggregationField((UserTaskDurationTime)userTaskDurationTime), new String[0]))).collect(MapUtil.pairCollector());
    }

    @Override
    public CompositeCommandResult.ViewResult retrieveResult(SearchResponse<RawResult> response, Map<String, Aggregate> aggs, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        CompositeCommandResult.ViewResult.ViewResultBuilder viewResultBuilder = CompositeCommandResult.ViewResult.builder();
        context.getReportData().getConfiguration().getUserTaskDurationTimes().forEach(userTaskDurationTime -> this.getAggregationStrategies((ProcessReportDataDto)context.getReportData()).forEach(aggregationStrategy -> {
            Double measureResult = this.getMeasureResult((AggregationStrategyOS)aggregationStrategy, (UserTaskDurationTime)userTaskDurationTime, aggs);
            viewResultBuilder.viewMeasure(this.buildViewMeasure((AggregationStrategyOS)aggregationStrategy, (UserTaskDurationTime)userTaskDurationTime, measureResult));
        }));
        return viewResultBuilder.build();
    }

    @Override
    public CompositeCommandResult.ViewResult createEmptyResult(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        CompositeCommandResult.ViewResult.ViewResultBuilder viewResultBuilder = CompositeCommandResult.ViewResult.builder();
        context.getReportData().getConfiguration().getUserTaskDurationTimes().forEach(userTaskDurationTime -> this.getAggregationStrategies((ProcessReportDataDto)context.getReportData()).forEach(aggregationStrategy -> viewResultBuilder.viewMeasure(this.buildViewMeasure((AggregationStrategyOS)aggregationStrategy, (UserTaskDurationTime)userTaskDurationTime, null))));
        return viewResultBuilder.build();
    }

    private Double getMeasureResult(AggregationStrategyOS aggregationStrategy, UserTaskDurationTime userTaskDurationTime, Map<String, Aggregate> aggs) {
        Double measureResult = aggregationStrategy.getValue(userTaskDurationTime.getId(), aggs);
        if (measureResult != null) {
            measureResult = Precision.round((double)measureResult, (int)0);
        }
        return measureResult;
    }

    private CompositeCommandResult.ViewMeasure buildViewMeasure(AggregationStrategyOS aggregationStrategy, UserTaskDurationTime userTaskDurationTime, Double measureResult) {
        return CompositeCommandResult.ViewMeasure.builder().aggregationType(aggregationStrategy.getAggregationType()).userTaskDurationTime(userTaskDurationTime).value(measureResult).build();
    }

    private Script getScriptedAggregationField(UserTaskDurationTime userTaskDurationTime) {
        return DurationScriptUtilOS.getUserTaskDurationScript(LocalDateUtil.getCurrentDateTime().toInstant().toEpochMilli(), this.getDurationFieldName(userTaskDurationTime));
    }

    private String getDurationFieldName(UserTaskDurationTime userTaskDurationTime) {
        return "flowNodeInstances." + userTaskDurationTime.getDurationFieldName();
    }
}

