/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.view.process;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.ProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.result.raw.RawDataProcessInstanceDto;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.dto.optimize.query.variable.ProcessVariableNameResponseDto;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.client.dsl.UnitDSL;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.ProcessViewInterpreterOS;
import io.camunda.optimize.service.db.os.writer.OpenSearchWriterUtil;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.util.RawProcessDataResultDtoMapper;
import io.camunda.optimize.service.db.report.interpreter.view.process.AbstractProcessViewRawDataInterpreter;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.db.repository.os.VariableRepositoryOS;
import io.camunda.optimize.service.db.util.ProcessVariableHelper;
import io.camunda.optimize.service.exceptions.ExceptionHelper;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.security.util.LocalDateUtil;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.ScriptSortType;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.mapping.FieldType;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessViewRawDataInterpreterOS
extends AbstractProcessViewRawDataInterpreter
implements ProcessViewInterpreterOS {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessViewRawDataInterpreterOS.class);
    private final ConfigurationService configurationService;
    private final ObjectMapper objectMapper;
    private final OptimizeOpenSearchClient osClient;
    private final DefinitionService definitionService;
    private final VariableRepositoryOS variableRepository;

    public ProcessViewRawDataInterpreterOS(ConfigurationService configurationService, ObjectMapper objectMapper, OptimizeOpenSearchClient osClient, DefinitionService definitionService, VariableRepositoryOS variableRepository) {
        this.configurationService = configurationService;
        this.objectMapper = objectMapper;
        this.osClient = osClient;
        this.definitionService = definitionService;
        this.variableRepository = variableRepository;
    }

    @Override
    public void adjustSearchRequest(SearchRequest.Builder searchRequestBuilder, Query baseQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        context.setAllVariablesNames(this.allVariableNamesForMatchingInstances(baseQuery, context));
        searchRequestBuilder.source(b -> b.fetch(Boolean.valueOf(true)));
        if (!context.isJsonExport()) {
            searchRequestBuilder.source(QueryDSL.sourceExclude((String[])new String[]{"flowNodeInstances"}));
        }
        if (context.isCsvExport()) {
            context.getPagination().ifPresent(pag -> searchRequestBuilder.size(Integer.valueOf(pag.getLimit() > 10000 ? 10000 : pag.getLimit())));
            searchRequestBuilder.scroll(UnitDSL.seconds((long)this.configurationService.getOpenSearchConfiguration().getScrollTimeoutInSeconds()));
        } else {
            context.getPagination().ifPresent(pag -> {
                if (pag.getLimit() > 10000) {
                    pag.setLimit(Integer.valueOf(10000));
                }
                searchRequestBuilder.size(pag.getLimit()).from(pag.getOffset());
            });
        }
        HashMap<String, JsonData> params = new HashMap<String, JsonData>();
        params.put("currentTime", QueryDSL.json((Object)LocalDateUtil.getCurrentDateTime().toInstant().toEpochMilli()));
        params.put("dateFormat", QueryDSL.json((Object)"yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        searchRequestBuilder.scriptFields(Map.of("currentTime", QueryDSL.scriptField((Script)OpenSearchWriterUtil.createDefaultScriptWithSpecificDtoParams("params.currentTime", params)), "numberOfUserTasks", QueryDSL.scriptField((Script)OpenSearchWriterUtil.createDefaultScript("Optional.ofNullable(params._source.flowNodeInstances)\n  .map(list -> list.stream().filter(item -> item.flowNodeType.equals('userTask')).count())\n  .orElse(0L)\n")), "flowNodeIdsToDurations", QueryDSL.scriptField((Script)OpenSearchWriterUtil.createDefaultScriptWithSpecificDtoParams("def flowNodeInstanceIdToDuration = new HashMap();\ndef dateFormatter = new SimpleDateFormat(params.dateFormat);\nfor (flowNodeInstance in params._source.flowNodeInstances) {\n  if (flowNodeInstance.totalDurationInMs != null) {\n    if (flowNodeInstanceIdToDuration.containsKey(flowNodeInstance.flowNodeId)) {\n      def currentDuration = flowNodeInstanceIdToDuration.get(flowNodeInstance.flowNodeId);\n      flowNodeInstanceIdToDuration.put(flowNodeInstance.flowNodeId, flowNodeInstance.totalDurationInMs + currentDuration)\n    } else {\n      flowNodeInstanceIdToDuration.put(flowNodeInstance.flowNodeId, flowNodeInstance.totalDurationInMs)\n    }\n  } else {\n    if (flowNodeInstance.startDate != null) {\n      def duration = params.currentTime - dateFormatter.parse(flowNodeInstance.startDate).getTime();\n      if (flowNodeInstanceIdToDuration.containsKey(flowNodeInstance.flowNodeId)) {\n        def currentDuration = flowNodeInstanceIdToDuration.get(flowNodeInstance.flowNodeId);\n        flowNodeInstanceIdToDuration.put(flowNodeInstance.flowNodeId, duration + currentDuration)\n      } else {\n        flowNodeInstanceIdToDuration.put(flowNodeInstance.flowNodeId, duration)\n      }\n    }\n  }\n}\nreturn flowNodeInstanceIdToDuration;\n", params))));
        this.addSorting(this.sortByField(context), this.sortOrder(context), searchRequestBuilder, params);
    }

    @Override
    public Map<String, Aggregation> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return Map.of();
    }

    @Override
    public CompositeCommandResult.ViewResult retrieveResult(SearchResponse<RawResult> response, Map<String, Aggregate> aggs, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        HashMap<String, Map<String, Long>> processInstanceIdsToFlowNodeIdsAndDurations = new HashMap<String, Map<String, Long>>();
        HashMap<String, Long> instanceIdsToUserTaskCount = new HashMap<String, Long>();
        ArrayList hits = new ArrayList();
        if (context.isCsvExport()) {
            int limit = context.getPagination().orElse(new PaginationDto()).getLimit();
            this.osClient.scrollWith(response, hits::addAll, RawResult.class, limit);
        } else {
            hits.addAll(response.hits().hits());
        }
        List<ProcessInstanceDto> rawDataProcessInstanceDtos = hits.stream().map(this.mappingFunction(processInstanceIdsToFlowNodeIdsAndDurations, instanceIdsToUserTaskCount, context)).toList();
        RawProcessDataResultDtoMapper rawDataSingleReportResultDtoMapper = new RawProcessDataResultDtoMapper();
        Map<String, String> flowNodeIdsToFlowNodeNames = this.definitionService.fetchDefinitionFlowNodeNamesAndIdsForProcessInstances(rawDataProcessInstanceDtos);
        List<RawDataProcessInstanceDto> rawData = rawDataSingleReportResultDtoMapper.mapFrom(rawDataProcessInstanceDtos, this.objectMapper, context.getAllVariablesNames(), instanceIdsToUserTaskCount, processInstanceIdsToFlowNodeIdsAndDurations, flowNodeIdsToFlowNodeNames);
        this.addNewVariablesAndDtoFieldsToTableColumnConfig(context, rawData);
        return CompositeCommandResult.ViewResult.builder().rawData(rawData).build();
    }

    private <R> R getField(Hit<RawResult> hit, String field) {
        try {
            List values = (List)this.objectMapper.readValue(((JsonData)hit.fields().get(field)).toJson().toString(), List.class);
            return (R)values.get(0);
        }
        catch (Exception e) {
            throw new OptimizeRuntimeException(String.format("Failed to extract %s from response!", field), (Throwable)e);
        }
    }

    private Function<Hit<RawResult>, ProcessInstanceDto> mappingFunction(Map<String, Map<String, Long>> processInstanceIdsToFlowNodeIdsAndDurations, Map<String, Long> instanceIdsToUserTaskCount, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return hit -> {
            try {
                ProcessInstanceDto processInstance = this.transformHit((Hit<RawResult>)hit);
                Map flowNodeIdsToDurations = (Map)this.getField((Hit<RawResult>)hit, "flowNodeIdsToDurations");
                Long numberOfUserTasks = ((Integer)this.getField((Hit<RawResult>)hit, "numberOfUserTasks")).longValue();
                processInstanceIdsToFlowNodeIdsAndDurations.put(processInstance.getProcessInstanceId(), flowNodeIdsToDurations);
                instanceIdsToUserTaskCount.put(processInstance.getProcessInstanceId(), numberOfUserTasks);
                if (processInstance.getDuration() == null && processInstance.getStartDate() != null) {
                    Optional sorting = context.getReportConfiguration().getSorting();
                    if (sorting.isPresent() && ((ReportSortingDto)sorting.get()).getBy().isPresent() && "duration".equals(((ReportSortingDto)sorting.get()).getBy().get())) {
                        processInstance.setDuration(Long.valueOf(Math.round(Double.parseDouble((String)hit.sort().get(0)))));
                    } else {
                        long currentTime = (Long)this.getField((Hit<RawResult>)hit, "currentTime");
                        processInstance.setDuration(Long.valueOf(currentTime - processInstance.getStartDate().toInstant().toEpochMilli()));
                    }
                }
                return processInstance;
            }
            catch (NumberFormatException exception) {
                throw new OptimizeRuntimeException("Error while parsing fields to numbers");
            }
        };
    }

    private Set<String> allVariableNamesForMatchingInstances(Query baseQuery, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        BoolQuery.Builder variableQuery = new BoolQuery.Builder().must(baseQuery, new Query[0]);
        return this.variableRepository.getVariableNamesForInstancesMatchingQuery(this.defKeysToTarget(context.getReportData().getDefinitions()), variableQuery, Map.of()).stream().map(ProcessVariableNameResponseDto::getName).collect(Collectors.toSet());
    }

    private SortOrder sortOrder(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return context.getReportConfiguration().getSorting().flatMap(ReportSortingDto::getOrder).map(QueryDSL::transformSortOrder).map(order -> SortOrder.valueOf((String)order.name())).orElse(SortOrder.Desc);
    }

    private ProcessInstanceDto transformHit(Hit<RawResult> hit) {
        return (ProcessInstanceDto)ExceptionHelper.safe(() -> (ProcessInstanceDto)this.objectMapper.readValue(this.objectMapper.writeValueAsString(hit.source()), ProcessInstanceDto.class), e -> String.format("While mapping search results to class {} it was not possible to deserialize a hit from OpenSearch! Hit response from OpenSearch: " + String.valueOf(hit.source()), new Object[0]), (Logger)LOG);
    }

    private void addSorting(String sortByField, SortOrder sortOrder, SearchRequest.Builder searchRequestBuilder, Map<String, JsonData> params) {
        if (sortByField.startsWith("variable:")) {
            String variableName = sortByField.substring("variable:".length());
            searchRequestBuilder.sort(SortOptions.of(so -> so.field(f -> f.field(ProcessVariableHelper.getNestedVariableValueField()).order(sortOrder).nested(n -> n.path("variables").filter(QueryDSL.term((String)ProcessVariableHelper.getNestedVariableNameField(), (String)variableName))))), new SortOptions[0]);
        } else if (sortByField.equals("duration")) {
            params.put("duration", QueryDSL.json((Object)"duration"));
            params.put("startDate", QueryDSL.json((Object)"startDate"));
            Script script = OpenSearchWriterUtil.createDefaultScriptWithSpecificDtoParams("if (doc[params.duration].size() == 0) {\n  params.currentTime - doc[params.startDate].value.toInstant().toEpochMilli()\n} else {\n   doc[params.duration].value\n}\n", params);
            searchRequestBuilder.sort(SortOptions.of(so -> so.script(s -> s.script(script).type(ScriptSortType.Number).order(sortOrder))), new SortOptions[0]);
        } else {
            searchRequestBuilder.sort(SortOptions.of(so -> so.field(f -> f.field(sortByField).order(sortOrder).unmappedType(FieldType.Short))), new SortOptions[0]);
        }
    }
}

