/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.view.decision;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.optimize.dto.optimize.importing.DecisionInstanceDto;
import io.camunda.optimize.dto.optimize.query.report.single.SingleReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.decision.result.raw.RawDataDecisionInstanceDto;
import io.camunda.optimize.dto.optimize.query.sorting.ReportSortingDto;
import io.camunda.optimize.dto.optimize.query.sorting.SortOrder;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.dto.optimize.rest.pagination.PaginationDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.client.dsl.UnitDSL;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.view.decision.DecisionViewInterpreterOS;
import io.camunda.optimize.service.db.reader.DecisionVariableReader;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.view.decision.AbstractDecisionViewRawDataInterpreter;
import io.camunda.optimize.service.db.report.plan.decision.DecisionExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.exceptions.ExceptionHelper;
import io.camunda.optimize.service.util.DecisionVariableHelper;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.NestedSortValue;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class DecisionViewRawDataInterpreterOS
extends AbstractDecisionViewRawDataInterpreter
implements DecisionViewInterpreterOS {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionViewRawDataInterpreterOS.class);
    private final ConfigurationService configurationService;
    private final ObjectMapper objectMapper;
    private final OptimizeOpenSearchClient osClient;
    private final DecisionVariableReader decisionVariableReader;

    public DecisionViewRawDataInterpreterOS(ConfigurationService configurationService, ObjectMapper objectMapper, OptimizeOpenSearchClient osClient, DecisionVariableReader decisionVariableReader) {
        this.configurationService = configurationService;
        this.objectMapper = objectMapper;
        this.osClient = osClient;
        this.decisionVariableReader = decisionVariableReader;
    }

    @Override
    public void adjustSearchRequest(SearchRequest.Builder searchRequestBuilder, Query baseQuery, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        searchRequestBuilder.source(b -> b.fetch(Boolean.valueOf(true)));
        context.getPagination().ifPresent(pag -> {
            if (context.isCsvExport()) {
                searchRequestBuilder.size(Integer.valueOf(pag.getLimit() > 10000 ? 10000 : pag.getLimit()));
                searchRequestBuilder.scroll(UnitDSL.seconds((long)this.configurationService.getOpenSearchConfiguration().getScrollTimeoutInSeconds()));
            } else {
                if (pag.getLimit() > 10000) {
                    pag.setLimit(Integer.valueOf(10000));
                }
                searchRequestBuilder.size(pag.getLimit()).from(pag.getOffset());
            }
        });
        this.addSortingToQuery(context.getReportData(), searchRequestBuilder);
    }

    @Override
    public Map<String, Aggregation> createAggregations(ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        return Map.of();
    }

    @Override
    public CompositeCommandResult.ViewResult retrieveResult(SearchResponse<RawResult> response, Map<String, Aggregate> aggs, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        List hits = response.hits().hits();
        if (context.isCsvExport()) {
            int limit = context.getPagination().orElse(new PaginationDto()).getLimit();
            ArrayList rawResult = new ArrayList();
            this.osClient.scrollWith(response, rawResult::addAll, RawResult.class, limit);
            hits = rawResult.subList(0, Math.min(limit, rawResult.size()));
        }
        List<DecisionInstanceDto> rawDataDecisionInstanceDtos = this.transformHits(hits);
        List<RawDataDecisionInstanceDto> rawData = this.rawDataSingleReportResultDtoMapper.mapFrom(rawDataDecisionInstanceDtos, this.getInputVariableEntries((SingleReportDataDto)context.getReportData()), this.getOutputVars((SingleReportDataDto)context.getReportData()));
        this.addNewVariablesAndDtoFieldsToTableColumnConfig(context, rawData);
        return CompositeCommandResult.ViewResult.builder().rawData(rawData).build();
    }

    @Override
    public CompositeCommandResult.ViewResult createEmptyResult(ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        return CompositeCommandResult.ViewResult.builder().rawData(new ArrayList()).build();
    }

    private List<DecisionInstanceDto> transformHits(List<Hit<RawResult>> rawResult) {
        return rawResult.stream().map(hit -> (DecisionInstanceDto)ExceptionHelper.safe(() -> (DecisionInstanceDto)this.objectMapper.readValue(this.objectMapper.writeValueAsString(hit.source()), DecisionInstanceDto.class), e -> String.format("While mapping search results to class {} it was not possible to deserialize a hit from OpenSearch! Hit response from OpenSearch: " + String.valueOf(hit.source()), new Object[0]), (Logger)LOG)).toList();
    }

    private void addSortingToQuery(DecisionReportDataDto decisionReportData, SearchRequest.Builder searchRequestBuilder) {
        Optional customSorting = decisionReportData.getConfiguration().getSorting();
        String sortByField = customSorting.flatMap(ReportSortingDto::getBy).orElse("evaluationDateTime");
        org.opensearch.client.opensearch._types.SortOrder sortOrder = customSorting.flatMap(ReportSortingDto::getOrder).map(order -> QueryDSL.transformSortOrder((SortOrder)order)).orElse(org.opensearch.client.opensearch._types.SortOrder.Desc);
        SortOptions defaultSortOptions = (SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(sortByField).order(sortOrder).build()).build();
        List<SortOptions> sortOptions = List.of(defaultSortOptions);
        if (sortByField.startsWith("inputVariable:")) {
            sortOptions = this.sortOptionsByInputVariable(sortByField, sortOrder);
        } else if (sortByField.startsWith("outputVariable:")) {
            sortOptions = this.sortOptionsByOutputVariable(sortByField, sortOrder);
        }
        searchRequestBuilder.sort(sortOptions);
    }

    private List<SortOptions> sortOptionsByInputVariable(String sortByField, org.opensearch.client.opensearch._types.SortOrder sortOrder) {
        SortOptions defaultSortOptions = this.createSortByVariable(sortByField, sortOrder, "inputVariable:", "inputs", VariableType.STRING);
        List<SortOptions> variableSortOptions = DecisionVariableHelper.getVariableMultivalueFields().stream().map(type -> this.createSortByVariable(sortByField, sortOrder, "inputVariable:", "inputs", (VariableType)type)).toList();
        ArrayList<SortOptions> sortOptions = new ArrayList<SortOptions>(variableSortOptions);
        sortOptions.add(defaultSortOptions);
        return sortOptions;
    }

    private List<SortOptions> sortOptionsByOutputVariable(String sortByField, org.opensearch.client.opensearch._types.SortOrder sortOrder) {
        SortOptions defaultSortOptions = this.createSortByVariable(sortByField, sortOrder, "outputVariable:", "outputs", VariableType.STRING);
        List<SortOptions> variableSortOptions = DecisionVariableHelper.getVariableMultivalueFields().stream().map(type -> this.createSortByVariable(sortByField, sortOrder, "outputVariable:", "outputs", (VariableType)type)).toList();
        ArrayList<SortOptions> sortOptions = new ArrayList<SortOptions>(variableSortOptions);
        sortOptions.add(defaultSortOptions);
        return sortOptions;
    }

    private SortOptions createSortByVariable(String sortByField, org.opensearch.client.opensearch._types.SortOrder sortOrder, String prefix, String variablePath, VariableType type) {
        String inputVariableId = sortByField.substring(prefix.length());
        String variableValuePath = DecisionVariableHelper.getVariableValueFieldForType(variablePath, type);
        String variableIdPath = DecisionVariableHelper.getVariableClauseIdField(variablePath);
        return (SortOptions)new SortOptions.Builder().field(new FieldSort.Builder().field(variableValuePath).nested(new NestedSortValue.Builder().path(variablePath).filter(QueryDSL.term((String)variableIdPath, (String)inputVariableId)).build()).order(sortOrder).build()).build();
    }

    @Override
    public DecisionVariableReader getDecisionVariableReader() {
        return this.decisionVariableReader;
    }
}

