/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.view.decision;

import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.view.decision.DecisionViewInterpreterOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.decision.DecisionExecutionPlan;
import io.camunda.optimize.service.db.report.plan.decision.DecisionView;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.Map;
import java.util.Set;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class DecisionViewInstanceFrequencyInterpreterOS
implements DecisionViewInterpreterOS {
    @Override
    public Set<DecisionView> getSupportedViews() {
        return Set.of(DecisionView.DECISION_VIEW_INSTANCE_FREQUENCY);
    }

    @Override
    public Map<String, Aggregation> createAggregations(ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        return Map.of("_frequency", new Aggregation.Builder().filter(QueryDSL.matchAll()).build());
    }

    @Override
    public CompositeCommandResult.ViewResult retrieveResult(SearchResponse<RawResult> response, Map<String, Aggregate> aggs, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        long count = aggs.get("_frequency").filter().docCount();
        return this.createViewResult(count);
    }

    @Override
    public CompositeCommandResult.ViewResult createEmptyResult(ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        return this.createViewResult(0.0);
    }

    private CompositeCommandResult.ViewResult createViewResult(double value) {
        return CompositeCommandResult.ViewResult.builder().viewMeasure(CompositeCommandResult.ViewMeasure.builder().value(value).build()).build();
    }
}

