/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.process.flownode;

import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.os.report.filter.util.ModelElementFilterQueryUtilOS;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.AbstractProcessGroupByInterpreterOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import java.util.Map;
import java.util.Optional;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregate;
import org.opensearch.client.opensearch._types.aggregations.SingleBucketAggregateBase;
import org.opensearch.client.opensearch.core.SearchResponse;

public abstract class AbstractGroupByFlowNodeInterpreterOS
extends AbstractProcessGroupByInterpreterOS {
    private static final String FLOW_NODES_AGGREGATION = "flowNodes";
    private static final String FILTERED_FLOW_NODES_AGGREGATION = "filteredFlowNodes";

    protected abstract DefinitionService getDefinitionService();

    protected Map<String, Aggregation> createFilteredFlowNodeAggregation(ExecutionContext<ProcessReportDataDto, ?> context, Map<String, Aggregation> subAggregations) {
        Aggregation filteredFlowNodesAggregation = new Aggregation.Builder().filter(ModelElementFilterQueryUtilOS.createModelElementAggregationFilter(context.getReportData(), context.getFilterContext(), this.getDefinitionService()).build().toQuery()).aggregations(subAggregations).build();
        Aggregation aggregation = new Aggregation.Builder().nested(n -> n.path("flowNodeInstances")).aggregations(FILTERED_FLOW_NODES_AGGREGATION, filteredFlowNodesAggregation).build();
        return Map.of(FLOW_NODES_AGGREGATION, aggregation);
    }

    protected Optional<FilterAggregate> getFilteredFlowNodesAggregation(SearchResponse<RawResult> response) {
        return this.getFlowNodesAggregation(response).map(SingleBucketAggregateBase::aggregations).map(aggs -> ((Aggregate)aggs.get(FILTERED_FLOW_NODES_AGGREGATION)).filter());
    }

    protected Optional<NestedAggregate> getFlowNodesAggregation(SearchResponse<RawResult> response) {
        return Optional.ofNullable(response.aggregations()).filter(aggs -> !aggs.isEmpty()).flatMap(aggs -> Optional.ofNullable(((Aggregate)aggs.get(FLOW_NODES_AGGREGATION)).nested()));
    }
}

