/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.process;

import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.VariableGroupByDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.group.value.VariableGroupByValueDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.DefinitionService;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.process.ProcessDistributedByInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.AbstractGroupByVariableInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.process.ProcessGroupByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.ProcessViewInterpreterFacadeOS;
import io.camunda.optimize.service.db.os.report.service.VariableAggregationServiceOS;
import io.camunda.optimize.service.db.os.util.ProcessVariableHelperOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.plan.process.ProcessGroupBy;
import io.camunda.optimize.service.db.util.ProcessVariableHelper;
import io.camunda.optimize.service.util.InstanceIndexUtil;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.Set;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessGroupByVariableInterpreterOS
extends AbstractGroupByVariableInterpreterOS<ProcessReportDataDto, ProcessExecutionPlan>
implements ProcessGroupByInterpreterOS {
    private final VariableAggregationServiceOS variableAggregationService;
    private final DefinitionService definitionService;
    private final ProcessDistributedByInterpreterFacadeOS distributedByInterpreter;
    private final ProcessViewInterpreterFacadeOS viewInterpreter;

    public ProcessGroupByVariableInterpreterOS(VariableAggregationServiceOS variableAggregationService, DefinitionService definitionService, ProcessDistributedByInterpreterFacadeOS distributedByInterpreter, ProcessViewInterpreterFacadeOS viewInterpreter) {
        this.variableAggregationService = variableAggregationService;
        this.definitionService = definitionService;
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public Set<ProcessGroupBy> getSupportedGroupBys() {
        return Set.of(ProcessGroupBy.PROCESS_GROUP_BY_VARIABLE);
    }

    private VariableGroupByValueDto getVariableGroupByDto(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return (VariableGroupByValueDto)((VariableGroupByDto)context.getReportData().getGroupBy()).getValue();
    }

    @Override
    protected String getVariableName(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return this.getVariableGroupByDto(context).getName();
    }

    @Override
    protected VariableType getVariableType(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return this.getVariableGroupByDto(context).getType();
    }

    @Override
    protected String getNestedVariableNameFieldLabel() {
        return ProcessVariableHelper.getNestedVariableNameField();
    }

    @Override
    protected String getNestedVariableTypeField() {
        return ProcessVariableHelper.getNestedVariableTypeField();
    }

    @Override
    protected String getNestedVariableValueFieldLabel(VariableType type) {
        return ProcessVariableHelper.getNestedVariableValueFieldForType(type);
    }

    @Override
    protected String getVariablePath() {
        return "variables";
    }

    @Override
    protected String[] getIndexNames(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return InstanceIndexUtil.getProcessInstanceIndexAliasNames((ProcessReportDataDto)context.getReportData());
    }

    @Override
    protected Query getVariableUndefinedOrNullQuery(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        VariableGroupByValueDto variable = this.getVariableGroupByDto(context);
        return ProcessVariableHelperOS.createFilterForUndefinedOrNullQuery(variable.getName(), variable.getType());
    }

    @Override
    public VariableAggregationServiceOS getVariableAggregationService() {
        return this.variableAggregationService;
    }

    @Override
    public DefinitionService getDefinitionService() {
        return this.definitionService;
    }

    public ProcessDistributedByInterpreterFacadeOS getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public ProcessViewInterpreterFacadeOS getViewInterpreter() {
        return this.viewInterpreter;
    }
}

