/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.groupby.decision;

import io.camunda.optimize.dto.optimize.query.report.single.decision.DecisionReportDataDto;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.decision.DecisionDistributedByNoneInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.groupby.decision.AbstractDecisionGroupByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.decision.DecisionViewInterpreterFacadeOS;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.plan.decision.DecisionExecutionPlan;
import io.camunda.optimize.service.db.report.plan.decision.DecisionGroupBy;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class DecisionGroupByMatchedRuleInterpreterOS
extends AbstractDecisionGroupByInterpreterOS {
    private static final String MATCHED_RULES_AGGREGATION = "matchedRules";
    private final ConfigurationService configurationService;
    private final DecisionDistributedByNoneInterpreterOS distributedByInterpreter;
    private final DecisionViewInterpreterFacadeOS viewInterpreter;

    public DecisionGroupByMatchedRuleInterpreterOS(ConfigurationService configurationService, DecisionDistributedByNoneInterpreterOS distributedByInterpreter, DecisionViewInterpreterFacadeOS viewInterpreter) {
        this.configurationService = configurationService;
        this.distributedByInterpreter = distributedByInterpreter;
        this.viewInterpreter = viewInterpreter;
    }

    @Override
    public Set<DecisionGroupBy> getSupportedGroupBys() {
        return Set.of(DecisionGroupBy.DECISION_GROUP_BY_MATCHED_RULE);
    }

    @Override
    public Map<String, Aggregation> createAggregation(Query query, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        return Map.of(MATCHED_RULES_AGGREGATION, new Aggregation.Builder().terms(TermsAggregation.of(b -> b.size(this.configurationService.getOpenSearchConfiguration().getAggregationBucketLimit()).field(MATCHED_RULES_AGGREGATION))).aggregations(this.distributedByInterpreter.createAggregations(context, query)).build());
    }

    @Override
    public void addQueryResult(CompositeCommandResult compositeCommandResult, SearchResponse<RawResult> response, ExecutionContext<DecisionReportDataDto, DecisionExecutionPlan> context) {
        List<CompositeCommandResult.GroupByResult> matchedRules = ((Aggregate)response.aggregations().get(MATCHED_RULES_AGGREGATION)).sterms().buckets().array().stream().map(bucket -> {
            List<CompositeCommandResult.DistributedByResult> distributions = this.distributedByInterpreter.retrieveResult(response, (Map<String, Aggregate>)bucket.aggregations(), context);
            return CompositeCommandResult.GroupByResult.createGroupByResult(bucket.key(), distributions);
        }).toList();
        compositeCommandResult.setGroups(matchedRules);
    }

    public DecisionDistributedByNoneInterpreterOS getDistributedByInterpreter() {
        return this.distributedByInterpreter;
    }

    public DecisionViewInterpreterFacadeOS getViewInterpreter() {
        return this.viewInterpreter;
    }
}

