/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.interpreter.distributedby.process;

import io.camunda.optimize.dto.optimize.query.report.single.process.ProcessReportDataDto;
import io.camunda.optimize.service.db.os.client.dsl.AggregationDSL;
import io.camunda.optimize.service.db.os.report.interpreter.RawResult;
import io.camunda.optimize.service.db.os.report.interpreter.distributedby.process.AbstractProcessDistributedByInterpreterOS;
import io.camunda.optimize.service.db.os.report.interpreter.view.process.ProcessViewInterpreterFacadeOS;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.db.report.ExecutionContext;
import io.camunda.optimize.service.db.report.interpreter.distributedby.process.ProcessDistributedByProcessInterpreter;
import io.camunda.optimize.service.db.report.plan.process.ProcessDistributedBy;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.db.report.result.CompositeCommandResult;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.StringTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessDistributedByProcessInterpreterOS
extends AbstractProcessDistributedByInterpreterOS
implements ProcessDistributedByProcessInterpreter {
    private final ProcessViewInterpreterFacadeOS viewInterpreter;
    private final ConfigurationService configurationService;
    private final ProcessDefinitionReader processDefinitionReader;

    public ProcessDistributedByProcessInterpreterOS(ProcessViewInterpreterFacadeOS viewInterpreter, ConfigurationService configurationService, ProcessDefinitionReader processDefinitionReader) {
        this.viewInterpreter = viewInterpreter;
        this.configurationService = configurationService;
        this.processDefinitionReader = processDefinitionReader;
    }

    @Override
    public Set<ProcessDistributedBy> getSupportedDistributedBys() {
        return Set.of(ProcessDistributedBy.PROCESS_DISTRIBUTED_BY_PROCESS);
    }

    @Override
    public Map<String, Aggregation> createAggregations(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context, Query baseQuery) {
        Integer size = this.configurationService.getOpenSearchConfiguration().getAggregationBucketLimit();
        Map<String, SortOrder> order = Map.of("_key", SortOrder.Asc);
        Aggregation tenantAgg = new Aggregation.Builder().terms(b -> b.size(size).order(order, new Map[0]).missing(FieldValue.of((String)"noTenant____")).field(this.tenantField(context))).aggregations(this.viewInterpreter.createAggregations(context)).build();
        return Map.of("processDefKeyAgg", AggregationDSL.withSubaggregations((TermsAggregation)AggregationDSL.termAggregation((String)this.definitionKeyField(context), (int)size, order), Map.of("processDefVersionAgg", AggregationDSL.withSubaggregations((TermsAggregation)AggregationDSL.termAggregation((String)this.definitionVersionField(context), (int)size, order), Map.of("tenantAgg", tenantAgg)))));
    }

    @Override
    public List<CompositeCommandResult.DistributedByResult> retrieveResult(SearchResponse<RawResult> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        Map<String, List<ProcessDistributedByProcessInterpreter.ProcessBucket>> bucketsByDefKey = this.extractBucketsByDefKey(response, aggregations, context);
        return this.retrieveResult(bucketsByDefKey, context);
    }

    @Override
    public CompositeCommandResult.ViewResult emptyViewResult(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return this.viewInterpreter.createEmptyResult(context);
    }

    @Override
    public List<CompositeCommandResult.DistributedByResult> createEmptyResult(ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        return this.emptyResult(context);
    }

    private Map<String, List<ProcessDistributedByProcessInterpreter.ProcessBucket>> extractBucketsByDefKey(SearchResponse<RawResult> response, Map<String, Aggregate> aggregations, ExecutionContext<ProcessReportDataDto, ProcessExecutionPlan> context) {
        HashMap<String, List<ProcessDistributedByProcessInterpreter.ProcessBucket>> bucketsByDefKey = new HashMap<String, List<ProcessDistributedByProcessInterpreter.ProcessBucket>>();
        StringTermsAggregate procDefKeyAgg = aggregations.get("processDefKeyAgg").sterms();
        if (procDefKeyAgg != null) {
            for (StringTermsBucket keyBucket : procDefKeyAgg.buckets().array()) {
                StringTermsAggregate procDefVersionAgg = ((Aggregate)keyBucket.aggregations().get("processDefVersionAgg")).sterms();
                if (procDefVersionAgg == null) continue;
                for (StringTermsBucket versionBucket : procDefVersionAgg.buckets().array()) {
                    StringTermsAggregate tenantTermsAgg = ((Aggregate)versionBucket.aggregations().get("tenantAgg")).sterms();
                    if (tenantTermsAgg == null) continue;
                    List<ProcessDistributedByProcessInterpreter.ProcessBucket> bucketsForKey = tenantTermsAgg.buckets().array().stream().map(tenantBucket -> new ProcessDistributedByProcessInterpreter.ProcessBucket(keyBucket.key(), versionBucket.key(), tenantBucket.key(), tenantBucket.docCount(), this.viewInterpreter.retrieveResult(response, (Map<String, Aggregate>)tenantBucket.aggregations(), context))).toList();
                    bucketsByDefKey.computeIfAbsent(keyBucket.key(), key -> new ArrayList()).addAll(bucketsForKey);
                }
            }
        }
        return bucketsByDefKey;
    }

    public ProcessViewInterpreterFacadeOS getViewInterpreter() {
        return this.viewInterpreter;
    }

    @Override
    public ProcessDefinitionReader getProcessDefinitionReader() {
        return this.processDefinitionReader;
    }
}

