/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report.filter;

import io.camunda.optimize.dto.optimize.query.report.single.filter.data.FilterOperator;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.OperatorMultipleValuesFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.date.DateFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.BooleanVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.DateVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.OperatorMultipleValuesVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.StringVariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.VariableFilterDataDto;
import io.camunda.optimize.dto.optimize.query.report.single.filter.data.variable.data.BooleanVariableFilterSubDataDto;
import io.camunda.optimize.dto.optimize.query.variable.VariableType;
import io.camunda.optimize.service.db.filter.util.OperatorMultipleValuesVariableFilterDataDtoUtil;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.report.filter.AbstractVariableQueryFilterOS;
import io.camunda.optimize.service.db.os.report.filter.util.DateFilterQueryUtilOS;
import io.camunda.optimize.service.db.os.util.ProcessVariableHelperOS;
import io.camunda.optimize.service.db.util.ProcessVariableHelper;
import io.camunda.optimize.service.util.ValidationHelper;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.NestedQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractProcessVariableQueryFilterOS
extends AbstractVariableQueryFilterOS {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProcessVariableQueryFilterOS.class);

    protected Query createFilterQuery(VariableFilterDataDto<?> dto, ZoneId timezone) {
        ValidationHelper.ensureNotNull("Variable filter data", dto.getData());
        Query query = QueryDSL.matchAll();
        switch (dto.getType()) {
            case STRING: {
                StringVariableFilterDataDto stringVarDto = (StringVariableFilterDataDto)dto;
                query = this.createStringQuery(stringVarDto);
                break;
            }
            case INTEGER: 
            case DOUBLE: 
            case SHORT: 
            case LONG: {
                OperatorMultipleValuesVariableFilterDataDto numericVarDto = (OperatorMultipleValuesVariableFilterDataDto)dto;
                query = this.createNumericQuery(numericVarDto);
                break;
            }
            case DATE: {
                DateVariableFilterDataDto dateVarDto = (DateVariableFilterDataDto)dto;
                query = this.createDateQuery(dateVarDto, timezone);
                break;
            }
            case BOOLEAN: {
                BooleanVariableFilterDataDto booleanVarDto = (BooleanVariableFilterDataDto)dto;
                query = this.createBooleanQuery(booleanVarDto);
                break;
            }
            default: {
                LOG.warn("Could not filter for variables! Type [{}] is not supported for variable filters. Ignoring filter.", (Object)dto.getType());
            }
        }
        return query;
    }

    @Override
    protected Query createContainsOneOfTheGivenStringsQuery(StringVariableFilterDataDto dto) {
        Query containOneOfTheGivenStrings = this.createContainsOneOfTheGivenStringsQuery(dto.getName(), ((OperatorMultipleValuesFilterDataDto)dto.getData()).getValues());
        return FilterOperator.NOT_CONTAINS.equals((Object)((OperatorMultipleValuesFilterDataDto)dto.getData()).getOperator()) ? QueryDSL.not((Query[])new Query[]{containOneOfTheGivenStrings}) : containOneOfTheGivenStrings;
    }

    @Override
    protected Query createContainsOneOfTheGivenStringsQuery(String variableName, List<String> values) {
        BoolQuery.Builder variableFilterBuilder = new BoolQuery.Builder().minimumShouldMatch("1");
        values.stream().filter(Objects::nonNull).forEach(stringVal -> variableFilterBuilder.should(this.createContainsGivenStringQuery(variableName, (String)stringVal), new Query[0]));
        boolean hasNullValues = values.stream().anyMatch(Objects::isNull);
        if (hasNullValues) {
            variableFilterBuilder.should(this.createFilterForUndefinedOrNullQuery(variableName, VariableType.STRING), new Query[0]);
        }
        return variableFilterBuilder.build().toQuery();
    }

    @Override
    protected Query createContainsGivenStringQuery(String variableName, String valueToContain) {
        String lowerCaseValue = valueToContain.toLowerCase(Locale.ENGLISH);
        Query filter = lowerCaseValue.length() > 10 ? QueryDSL.wildcardQuery((String)ProcessVariableHelper.getValueSearchField("lowercaseField"), (String)ProcessVariableHelper.buildWildcardQuery(lowerCaseValue)) : QueryDSL.term((String)ProcessVariableHelper.getValueSearchField("nGramField"), (String)lowerCaseValue);
        Query containsVariableString = QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)ProcessVariableHelper.getNestedVariableNameField(), (String)variableName), QueryDSL.term((String)ProcessVariableHelper.getNestedVariableTypeField(), (String)VariableType.STRING.getId()), filter});
        return QueryDSL.nested((String)"variables", (Query)containsVariableString, (ChildScoreMode)ChildScoreMode.None);
    }

    @Override
    protected Query createEqualsOneOrMoreValuesQuery(OperatorMultipleValuesVariableFilterDataDto dto) {
        Query query = this.createEqualsOneOrMoreValuesFilterQuery(dto.getName(), dto.getType(), ((OperatorMultipleValuesFilterDataDto)dto.getData()).getValues());
        return FilterOperator.NOT_IN.equals((Object)((OperatorMultipleValuesFilterDataDto)dto.getData()).getOperator()) ? QueryDSL.not((Query[])new Query[]{query}) : query;
    }

    @Override
    protected Query createBooleanQuery(BooleanVariableFilterDataDto dto) {
        ValidationHelper.ensureCollectionNotEmpty("boolean filter value", ((BooleanVariableFilterSubDataDto)dto.getData()).getValues());
        return this.createEqualsOneOrMoreValuesFilterQuery(dto.getName(), dto.getType(), ((BooleanVariableFilterSubDataDto)dto.getData()).getValues());
    }

    private Query createEqualsOneOrMoreValuesFilterQuery(String variableName, VariableType variableType, List<?> values) {
        boolean hasNullValues;
        BoolQuery.Builder variableFilterBuilder = new BoolQuery.Builder().minimumShouldMatch("1");
        String nestedVariableNameFieldLabel = ProcessVariableHelper.getNestedVariableNameField();
        String nestedVariableValueFieldLabel = this.getVariableValueFieldForType(variableType);
        List nonNullValues = values.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (!nonNullValues.isEmpty()) {
            variableFilterBuilder.should(new NestedQuery.Builder().path("variables").query(QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)nestedVariableNameFieldLabel, (String)variableName), QueryDSL.term((String)ProcessVariableHelper.getNestedVariableTypeField(), (String)variableType.getId()), QueryDSL.terms((String)nestedVariableValueFieldLabel, nonNullValues)})).scoreMode(ChildScoreMode.None).build().toQuery(), new Query[0]);
        }
        boolean bl = hasNullValues = nonNullValues.size() < values.size();
        if (hasNullValues) {
            variableFilterBuilder.should(this.createFilterForUndefinedOrNullQuery(variableName, variableType), new Query[0]);
        }
        return variableFilterBuilder.build().toQuery();
    }

    @Override
    protected Query createNumericQuery(OperatorMultipleValuesVariableFilterDataDto dto) {
        OperatorMultipleValuesVariableFilterDataDtoUtil.validateMultipleValuesFilterDataDto(dto);
        String nestedVariableValueFieldLabel = this.getVariableValueFieldForType(dto.getType());
        OperatorMultipleValuesFilterDataDto data = (OperatorMultipleValuesFilterDataDto)dto.getData();
        boolean isInOrNotIn = false;
        ArrayList<Query> queries = new ArrayList<Query>(List.of(QueryDSL.term((String)ProcessVariableHelper.getNestedVariableNameField(), (String)dto.getName()), QueryDSL.term((String)ProcessVariableHelper.getNestedVariableTypeField(), (String)dto.getType().getId())));
        Object value = OperatorMultipleValuesVariableFilterDataDtoUtil.retrieveValue(dto);
        switch (data.getOperator()) {
            case IN: 
            case NOT_IN: {
                isInOrNotIn = true;
                break;
            }
            case LESS_THAN: {
                queries.add(QueryDSL.lt((String)nestedVariableValueFieldLabel, (Object)value));
                break;
            }
            case GREATER_THAN: {
                queries.add(QueryDSL.gt((String)nestedVariableValueFieldLabel, (Object)value));
                break;
            }
            case LESS_THAN_EQUALS: {
                queries.add(QueryDSL.lte((String)nestedVariableValueFieldLabel, (Object)value));
                break;
            }
            case GREATER_THAN_EQUALS: {
                queries.add(QueryDSL.gte((String)nestedVariableValueFieldLabel, (Object)value));
                break;
            }
            default: {
                LOG.warn("Could not filter for variables! Operator [{}] is not supported for type [{}]. Ignoring filter.", (Object)data.getOperator(), (Object)dto.getType());
            }
        }
        Query query = new NestedQuery.Builder().path("variables").query(QueryDSL.and((Query[])queries.toArray(new Query[0]))).scoreMode(ChildScoreMode.None).build().toQuery();
        return isInOrNotIn ? this.createEqualsOneOrMoreValuesQuery(dto) : query;
    }

    @Override
    protected Query createDateQuery(DateVariableFilterDataDto dto, ZoneId timezone) {
        BoolQuery.Builder dateFilterBuilder = new BoolQuery.Builder().minimumShouldMatch("1");
        if (((DateFilterDataDto)dto.getData()).isIncludeUndefined()) {
            dateFilterBuilder.should(this.createFilterForUndefinedOrNullQuery(dto.getName(), dto.getType()), new Query[0]);
        } else if (((DateFilterDataDto)dto.getData()).isExcludeUndefined()) {
            dateFilterBuilder.should(this.createExcludeUndefinedOrNullQuery(dto.getName(), dto.getType()), new Query[0]);
        }
        BoolQuery.Builder dateValueFilterQueryBuilder = new BoolQuery.Builder().must(QueryDSL.term((String)ProcessVariableHelper.getNestedVariableNameField(), (String)dto.getName()), new Query[0]).must(QueryDSL.term((String)ProcessVariableHelper.getNestedVariableTypeField(), (String)dto.getType().getId()), new Query[0]);
        List<Query> filterQueries = DateFilterQueryUtilOS.filterQueries(List.of((DateFilterDataDto)dto.getData()), this.getVariableValueFieldForType(dto.getType()), timezone);
        if (!filterQueries.isEmpty()) {
            dateValueFilterQueryBuilder.filter(filterQueries);
            dateFilterBuilder.should(QueryDSL.nested((String)"variables", (Query)dateValueFilterQueryBuilder.build().toQuery(), (ChildScoreMode)ChildScoreMode.None), new Query[0]);
        }
        return dateFilterBuilder.build().toQuery();
    }

    private String getVariableValueFieldForType(VariableType type) {
        return ProcessVariableHelper.getNestedVariableValueFieldForType(type);
    }

    private Query createFilterForUndefinedOrNullQuery(String variableName, VariableType variableType) {
        return ProcessVariableHelperOS.createFilterForUndefinedOrNullQuery(variableName, variableType);
    }

    private Query createExcludeUndefinedOrNullQuery(String variableName, VariableType variableType) {
        return ProcessVariableHelperOS.createExcludeUndefinedOrNullQueryFilter(variableName, variableType);
    }
}

