/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.report;

import io.camunda.optimize.dto.optimize.query.report.ReportDefinitionDto;
import io.camunda.optimize.dto.optimize.query.report.single.process.SingleProcessReportDefinitionRequestDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.report.interpreter.plan.process.ProcessExecutionPlanInterpreterFacadeOS;
import io.camunda.optimize.service.db.report.CombinedReportInstanceCounter;
import io.camunda.optimize.service.db.report.ExecutionContextFactory;
import io.camunda.optimize.service.db.report.ExecutionPlanExtractor;
import io.camunda.optimize.service.db.report.ReportEvaluationContext;
import io.camunda.optimize.service.db.report.plan.process.ProcessExecutionPlan;
import io.camunda.optimize.service.exceptions.OptimizeRuntimeException;
import io.camunda.optimize.service.util.ExceptionUtil;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.io.IOException;
import java.util.List;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class CombinedReportInstanceCounterOS
extends CombinedReportInstanceCounter<BoolQuery.Builder> {
    private static final Logger LOG = LoggerFactory.getLogger(CombinedReportInstanceCounterOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ExecutionPlanExtractor executionPlanExtractor;
    private final ProcessExecutionPlanInterpreterFacadeOS interpreter;

    public CombinedReportInstanceCounterOS(OptimizeOpenSearchClient osClient, ExecutionPlanExtractor executionPlanExtractor, ProcessExecutionPlanInterpreterFacadeOS interpreter) {
        this.osClient = osClient;
        this.executionPlanExtractor = executionPlanExtractor;
        this.interpreter = interpreter;
    }

    @Override
    public long count(List<SingleProcessReportDefinitionRequestDto> singleReportDefinitions) {
        List<BoolQuery.Builder> baseQueries = this.getAllBaseQueries(singleReportDefinitions);
        BoolQuery.Builder instanceCountRequestQuery = this.createInstanceCountRequestQueries(baseQueries);
        try {
            return this.osClient.count(new String[]{"process-instance"}, instanceCountRequestQuery.build().toQuery());
        }
        catch (IOException e) {
            String message = String.format("Could not count instances in combined report with single report IDs: [%s]", singleReportDefinitions.stream().map(ReportDefinitionDto::getId));
            LOG.error(message, (Throwable)e);
            throw new OptimizeRuntimeException(message, (Throwable)e);
        }
        catch (RuntimeException e) {
            if (ExceptionUtil.isInstanceIndexNotFoundException((RuntimeException)e)) {
                LOG.info("Could not evaluate combined instance count because no instance indices exist. Returning a count of 0 instead.");
                return 0L;
            }
            throw e;
        }
    }

    @Override
    protected ExecutionPlanExtractor getExecutionPlanExtractor() {
        return this.executionPlanExtractor;
    }

    @Override
    protected BoolQuery.Builder getBaseQuery(ProcessExecutionPlan plan, ReportEvaluationContext<SingleProcessReportDefinitionRequestDto> context) {
        return this.interpreter.baseQueryBuilder(ExecutionContextFactory.buildExecutionContext(plan, context));
    }

    private BoolQuery.Builder createInstanceCountRequestQueries(List<BoolQuery.Builder> baseQueries) {
        BoolQuery.Builder baseQuery = new BoolQuery.Builder();
        baseQueries.forEach(q -> baseQuery.should(s -> s.bool(q.build())));
        return baseQuery;
    }
}

