/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.dto.optimize.SettingsDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.reader.SettingsReader;
import io.camunda.optimize.service.util.configuration.ConfigurationService;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.client.opensearch.core.GetRequest;
import org.opensearch.client.opensearch.core.GetResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class SettingsReaderOS
implements SettingsReader {
    private static final Logger LOG = LoggerFactory.getLogger(SettingsReaderOS.class);
    private final OptimizeOpenSearchClient osClient;
    private final ConfigurationService configurationService;

    public SettingsReaderOS(OptimizeOpenSearchClient osClient, ConfigurationService configurationService) {
        this.osClient = osClient;
        this.configurationService = configurationService;
    }

    @Override
    public Optional<SettingsDto> getSettings() {
        LOG.debug("Fetching Optimize Settings");
        GetRequest.Builder getReqBuilder = new GetRequest.Builder().index("settings").id("1");
        String errorMessage = "There was an error while reading settings for OpenSearch";
        GetResponse getResponse = this.osClient.get(getReqBuilder, SettingsDto.class, "There was an error while reading settings for OpenSearch");
        if (getResponse.found()) {
            SettingsDto result = (SettingsDto)getResponse.source();
            if (Objects.nonNull(result)) {
                if (result.getSharingEnabled().isEmpty()) {
                    result.setSharingEnabled(Boolean.valueOf(this.configurationService.getSharingEnabled()));
                }
                LOG.debug("Finished Fetching Optimize Settings");
                return Optional.of(result);
            }
        } else {
            LOG.debug("No Settings found");
        }
        return Optional.empty();
    }
}

