/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.dto.optimize.DefinitionType;
import io.camunda.optimize.dto.optimize.ProcessDefinitionOptimizeDto;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.os.reader.DefinitionReaderOS;
import io.camunda.optimize.service.db.os.reader.OpensearchReaderUtil;
import io.camunda.optimize.service.db.reader.DefinitionReader;
import io.camunda.optimize.service.db.reader.ProcessDefinitionReader;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.Optional;
import java.util.Set;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.SourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessDefinitionReaderOS
implements ProcessDefinitionReader {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessDefinitionReaderOS.class);
    private final DefinitionReaderOS definitionReader;
    private final OptimizeOpenSearchClient osClient;

    public ProcessDefinitionReaderOS(DefinitionReaderOS definitionReader, OptimizeOpenSearchClient osClient) {
        this.definitionReader = definitionReader;
        this.osClient = osClient;
    }

    @Override
    public Optional<ProcessDefinitionOptimizeDto> getProcessDefinition(String definitionId) {
        BoolQuery query = new BoolQuery.Builder().must(QueryDSL.matchAll(), new Query[0]).must(QueryDSL.term((String)"id", (String)definitionId), new Query[0]).build();
        return this.definitionReader.getDefinitions(DefinitionType.PROCESS, query, true).stream().findFirst().map(ProcessDefinitionOptimizeDto.class::cast);
    }

    @Override
    public Set<String> getAllNonOnboardedProcessDefinitionKeys() {
        String defKeyAgg = "keyAgg";
        Query query = new BoolQuery.Builder().must(QueryDSL.term((String)"onboarded", (boolean)false), new Query[0]).must(QueryDSL.term((String)"deleted", (boolean)false), new Query[0]).should(QueryDSL.exists((String)"bpmn20Xml"), new Query[0]).build().toQuery();
        SearchRequest.Builder searchRequest = new SearchRequest.Builder().index("process-definition", new String[0]).size(Integer.valueOf(10000)).query(query).aggregations("keyAgg", new TermsAggregation.Builder().field("key").build()._toAggregation()).source((SourceConfig)new SourceConfig.Builder().fetch(Boolean.valueOf(false)).build());
        String errorMessage = "Was not able to fetch non-onboarded process definition keys.";
        SearchResponse searchResponse = this.osClient.search(searchRequest, String.class, "Was not able to fetch non-onboarded process definition keys.");
        return OpensearchReaderUtil.extractAggregatedResponseValues(searchResponse, "keyAgg");
    }

    @Override
    public DefinitionReader getDefinitionReader() {
        return this.definitionReader;
    }
}

