/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.optimize.service.db.os.reader;

import io.camunda.optimize.service.db.os.OpenSearchCompositeAggregationScroller;
import io.camunda.optimize.service.db.os.OptimizeOpenSearchClient;
import io.camunda.optimize.service.db.os.client.dsl.AggregationDSL;
import io.camunda.optimize.service.db.os.client.dsl.QueryDSL;
import io.camunda.optimize.service.db.reader.AssigneeAndCandidateGroupsReader;
import io.camunda.optimize.service.util.DefinitionQueryUtilOS;
import io.camunda.optimize.service.util.configuration.condition.OpenSearchCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.CompositeAggregation;
import org.opensearch.client.opensearch._types.aggregations.CompositeAggregationSource;
import org.opensearch.client.opensearch._types.aggregations.CompositeTermsAggregationSource;
import org.opensearch.client.opensearch._types.aggregations.NestedAggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class AssigneeAndCandidateGroupsReaderOS
implements AssigneeAndCandidateGroupsReader {
    private static final Logger LOG = LoggerFactory.getLogger(AssigneeAndCandidateGroupsReaderOS.class);
    private final OptimizeOpenSearchClient osClient;

    public AssigneeAndCandidateGroupsReaderOS(OptimizeOpenSearchClient osClient) {
        this.osClient = osClient;
    }

    @Override
    public Set<String> getUserTaskFieldTerms(String userTaskFieldName, Map<String, Set<String>> definitionKeyToTenantsMap) {
        LOG.debug("Fetching {} for process definition with key and tenants [{}]", (Object)userTaskFieldName, definitionKeyToTenantsMap);
        HashSet<String> result = new HashSet<String>();
        if (!definitionKeyToTenantsMap.isEmpty()) {
            Query definitionQuery = DefinitionQueryUtilOS.createDefinitionQuery(definitionKeyToTenantsMap, "processDefinitionKey", "tenantId");
            this.consumeUserTaskFieldTermsInBatches(definitionQuery, userTaskFieldName, result::addAll);
        }
        return result;
    }

    @Override
    public void consumeUserTaskFieldTermsInBatches(String indexName, String termField, String termValue, String userTaskFieldName, Consumer<List<String>> termBatchConsumer, int batchSize) {
        Query filterQuery = QueryDSL.term((String)termField, (String)termValue);
        this.consumeUserTaskFieldTermsInBatches(indexName, filterQuery, userTaskFieldName, termBatchConsumer, batchSize);
    }

    private void consumeUserTaskFieldTermsInBatches(Query filterQuery, String fieldName, Consumer<List<String>> termBatchConsumer) {
        this.consumeUserTaskFieldTermsInBatches("process-instance", filterQuery, fieldName, termBatchConsumer, 10000);
    }

    private void consumeUserTaskFieldTermsInBatches(String indexName, Query filterQuery, String userTaskFieldName, Consumer<List<String>> termBatchConsumer, int batchSize) {
        boolean hasPage;
        int resolvedBatchSize = Math.min(batchSize, 10000);
        ArrayList<Map<String, CompositeAggregationSource>> sources = new ArrayList<Map<String, CompositeAggregationSource>>();
        sources.add(Collections.singletonMap("userTaskFieldTerms", new CompositeAggregationSource.Builder().terms(((CompositeTermsAggregationSource.Builder)new CompositeTermsAggregationSource.Builder().field(this.getUserTaskFieldPath(userTaskFieldName))).build()).build()));
        CompositeAggregation assigneeCompositeAgg = new CompositeAggregation.Builder().sources(sources).size(Integer.valueOf(resolvedBatchSize)).build();
        NestedAggregation nestedAgg = new NestedAggregation.Builder().path("flowNodeInstances").build();
        Aggregation userTasksAgg = AggregationDSL.withSubaggregations((NestedAggregation)nestedAgg, Collections.singletonMap("composite", assigneeCompositeAgg._toAggregation()));
        ArrayList termsBatch = new ArrayList();
        OpenSearchCompositeAggregationScroller compositeAggregationScroller = OpenSearchCompositeAggregationScroller.create().setClient(this.osClient).query(filterQuery).aggregations(Map.of("userTasks", userTasksAgg)).index(List.of(indexName)).size(0).setPathToAggregation("userTasks", "composite").setCompositeBucketConsumer(bucket -> termsBatch.add((String)((JsonData)bucket.key().get("userTaskFieldTerms")).to(String.class)));
        do {
            hasPage = compositeAggregationScroller.consumePage();
            termBatchConsumer.accept(termsBatch);
            termsBatch.clear();
        } while (hasPage);
    }
}

